package com.ejianc.business.promaterial.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeHisEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeHisService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材总计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("masterPlan")
@Api(value = "消耗材总计划", tags = {"消耗材总计划"})
public class MasterPlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecutionApi executionApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "MASTER_PLAN";//此处需要根据实际修改

    @Autowired
    private IMasterPlanService service;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IMasterPlanChangeHisService masterPlanChangeHisService;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MasterPlanVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MasterPlanVO masterPlanVo) {
        return service.saveOrUpdateMasterPlan(masterPlanVo, false);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MasterPlanVO> queryDetail(@RequestParam Long id) {
        MasterPlanVO vo = null;
        /*MasterPlanEntity dbEntity = service.selectById(id);
        if(null != dbEntity) {
            vo = BeanMapper.map(dbEntity, MasterPlanVO.class);

            if(MasterPlanVO.PLAN_CHANGE_STATE_CHANGED == vo.getChangeState()) {
                List<MasterPlanChangeHisVO> changeHisList = loadChangeHisList(vo.getId());
                vo.setMasterPlanChangeHisList(changeHisList);
            }
        }*/
        vo = service.queryDetail(id,true);

        return CommonResponse.success("查询物资总计划详情成功！", vo);
    }

    private List<MasterPlanChangeHisVO> loadChangeHisList(Long planId) {
        List<MasterPlanChangeHisVO> resp = new ArrayList<>();
        QueryWrapper<MasterPlanChangeHisEntity> hisQuery = new QueryWrapper<>();
        hisQuery.eq("source_plan_id", planId);
        hisQuery.orderByDesc("create_time");

        List<MasterPlanChangeHisEntity> list = masterPlanChangeHisService.list(hisQuery);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, MasterPlanChangeHisVO.class);
        }
        return  resp;
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MasterPlanVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)) {
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (MasterPlanVO masterPlanVO : vos) {
                MasterPlanEntity masterPlanEntity = service.selectById(masterPlanVO.getId());
                String billType;
                if (masterPlanEntity.getPlanType() == 0) {
                    billType = BillTypeEnum.消耗材总计划.getCode();
                }
                else {
                    billType = BillTypeEnum.混凝土总计划.getCode();
                }
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(masterPlanEntity,MasterPlanVO.class),"", billType, masterPlanEntity.getPlanType());
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
//                return CommonResponse.error("目标成本推送失败,"+response.getMsg());
            }
            List<Long> ids = vos.stream().map(MasterPlanVO::getId).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(ids)) {
                service.removeByIds(ids);
            }
        }
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MasterPlanVO>> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("planCode");
        /** 计划类型隔离 */
        queryParam.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.消耗材.getCode()));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!queryParam.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<MasterPlanEntity> page = service.queryPage(queryParam,false);
        IPage<MasterPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MasterPlanVO.class));

        return CommonResponse.success("分页查询物资总计划列表成功", pageData);
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
    @ApiOperation("混泥土查询列表")
    @RequestMapping(value = "/queryConcreteList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MasterPlanVO>> queryConcreteList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("planCode");
        /** 计划类型隔离 */
        queryParam.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.混泥土.getCode()));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!queryParam.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<MasterPlanEntity> page = service.queryPage(queryParam,false);
        IPage<MasterPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MasterPlanVO.class));
        return CommonResponse.success("分页查询物资总计划列表成功", pageData);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        if(null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childOrgResp = iOrgApi.findChildrenByParentId(orgId);

        List<Long> childIds = new ArrayList<>();
        //总计划直接跟项目关联，只查询本心的所有项目部即可
        childIds.addAll(childOrgResp.getData().stream().filter(org -> 5 == org.getOrgType()).map(OrgVO::getId).collect(Collectors.toList()));

        if(CollectionUtils.isEmpty(childIds)) {
            childIds.add(1L); //添加1项，以防报错
        }

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);

        return c1;
    }

    @ApiOperation("是否存在总计划")
    @GetMapping(value = "/projectPlanCheck")
    @ResponseBody
    public CommonResponse<String> projectPlanCheck(@RequestParam(value = "projectId") Long projectId,
                                                   @RequestParam(value = "billId", required = false) Long billId) {
        QueryWrapper<MasterPlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("plan_type", PlanTypeEnum.消耗材.getCode());
        MasterPlanEntity entityByProject = service.getOne(query);
        if(null != entityByProject && (null == billId || !entityByProject.getId().equals(billId))) {
            return CommonResponse.error("该项目下已存在消耗材总计划！");
        }
        return CommonResponse.success("该项目适用当前总计划！");
    }

    @ApiOperation("是否存在混泥土总计划")
    @GetMapping(value = "/projectConcretePlanCheck")
    @ResponseBody
    public CommonResponse<String> projectConcretePlanCheck(@RequestParam(value = "projectId") Long projectId,
                                                           @RequestParam(value = "billId", required = false) Long billId) {
        QueryWrapper<MasterPlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("plan_type", PlanTypeEnum.混泥土.getCode());
        MasterPlanEntity entityByProject = service.getOne(query);
        if(null != entityByProject && (null == billId || !entityByProject.getId().equals(billId))) {
            return CommonResponse.error("该项目下已存在混凝土总计划！");
        }
        return CommonResponse.success("该项目适用当前总计划！");
    }

    @ApiOperation("参照郑州一建物资控制")
    @RequestMapping(value = "/planMaterialListReferZzyj", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MasterPlanDetailRefVO>> planMaterialListReferZzyj(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                              String condition,
                                                                              String searchObject,
                                                                              String searchText) {
        IPage<MasterPlanDetailRefVO> resp = new Page<>();
        QueryParam queryParam = new QueryParam();
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.getFuzzyFields().add("material_category_name");
        queryParam.getFuzzyFields().add("material_name");
        queryParam.getFuzzyFields().add("spec");

        //按照物资Id正序排列
        queryParam.getOrderMap().put("id", QueryParam.ASC);
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);

        if(StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }

        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if(null == conditionMap.get("projectId")) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }
        if(null == conditionMap.get("planType")) {
            return CommonResponse.error("查询失败，参数condition中缺少项planType！");
        }
        if(null==conditionMap.get("postbytopictype")||!conditionMap.get("postbytopictype").equals(1)){//有且等于1则不过滤分类，反之过滤
            queryParam.getParams().put("materialId1", new Parameter(QueryParam.SQL,"material_id is not null"));
        }
        List<Integer> approvedBillState = new ArrayList<>();
        QueryWrapper<MasterPlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", conditionMap.get("projectId"));
        queryWrapper.eq("plan_type", conditionMap.get("planType"));//计划类型
        //查询审批通过
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in("bill_state", approvedBillState);
        MasterPlanEntity entity = service.getOne(queryWrapper);
        if(null == entity) {
            resp.setTotal(0L);
            resp.setSize(pageSize);
            resp.setCurrent(pageNumber);
            resp.setRecords(new ArrayList<>());
            resp.setPages(0);
        } else {
            queryParam.getParams().put("materialMasterPlanId", new Parameter(QueryParam.EQ, entity.getId()));

            CommonResponse<List<Long>> categoryIdList = shareMaterialApi.queryUnenabledCategoryListId();
            if (categoryIdList.getCode() == 0){
                List<Long> data = categoryIdList.getData();
                queryParam.getParams().put("materialCategoryId", new Parameter(QueryParam.NOT_IN, data));
            }

            IPage<MasterPlanDetailEntity> pageData = masterPlanDetailService.queryPage(queryParam, false);
            resp.setPages(pageData.getPages());
            resp.setCurrent(pageData.getCurrent());
            resp.setTotal(pageData.getTotal());
            resp.setSize(pageData.getSize());

            List<MasterPlanDetailRefVO> dataList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
                dataList = BeanMapper.mapList(pageData.getRecords(), MasterPlanDetailRefVO.class);
            }

            resp.setRecords(dataList);
        }

        return CommonResponse.success("查询参照数据成功！",resp);
    }
    @ApiOperation("参照")
    @RequestMapping(value = "/planMaterialListRefer", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MasterPlanDetailRefVO>> planMaterialListRefer(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                              String condition,
                                                                              String searchObject,
                                                                              String searchText) {
        IPage<MasterPlanDetailRefVO> resp = new Page<>();
        QueryParam queryParam = new QueryParam();
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.getFuzzyFields().add("material_category_name");
        queryParam.getFuzzyFields().add("material_name");
        queryParam.getFuzzyFields().add("spec");

        //按照物资Id正序排列
        queryParam.getOrderMap().put("id", QueryParam.ASC);
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);

        if(StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }

        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if(null == conditionMap.get("projectId")) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }
        if(null == conditionMap.get("planType")) {
            return CommonResponse.error("查询失败，参数condition中缺少项planType！");
        }
        if(null==conditionMap.get("postbytopictype")||!conditionMap.get("postbytopictype").equals(1)){//有且等于1则不过滤分类，反之过滤
            queryParam.getParams().put("materialId1", new Parameter(QueryParam.SQL,"material_id is not null"));
        }
        List<Integer> approvedBillState = new ArrayList<>();
        QueryWrapper<MasterPlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", conditionMap.get("projectId"));
        queryWrapper.eq("plan_type", conditionMap.get("planType"));//计划类型
        //查询审批通过
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in("bill_state", approvedBillState);
        MasterPlanEntity entity = service.getOne(queryWrapper);
        if(null == entity) {
            resp.setTotal(0L);
            resp.setSize(pageSize);
            resp.setCurrent(pageNumber);
            resp.setRecords(new ArrayList<>());
            resp.setPages(0);
        } else {
            queryParam.getParams().put("materialMasterPlanId", new Parameter(QueryParam.EQ, entity.getId()));
            IPage<MasterPlanDetailEntity> pageData = masterPlanDetailService.queryPage(queryParam, false);
            resp.setPages(pageData.getPages());
            resp.setCurrent(pageData.getCurrent());
            resp.setTotal(pageData.getTotal());
            resp.setSize(pageData.getSize());

            List<MasterPlanDetailRefVO> dataList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
                dataList = BeanMapper.mapList(pageData.getRecords(), MasterPlanDetailRefVO.class);
            }

            resp.setRecords(dataList);
        }

        return CommonResponse.success("查询参照数据成功！",resp);
    }
    @GetMapping(value = "/getContrastInfo")
    @ResponseBody
    public CommonResponse<List<MasterPlanContrastV0>> getContrastInfo(@RequestParam(value = "materialMasterPlanId") Long materialMasterPlanId,
                                                                      @RequestParam(value = "oldMaterialMasterPlanId") Long oldMaterialMasterPlanId) {

        List<MasterPlanContrastV0> list= service.getContrastInfo(materialMasterPlanId,oldMaterialMasterPlanId);

        return CommonResponse.success("获取对比数据成功！",list);
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 计划类型隔离 */
        param.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.消耗材.getCode()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MasterPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<MasterPlanExportVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            for(MasterPlanEntity val:list){
                MasterPlanExportVO vo = BeanMapper.map(val, MasterPlanExportVO.class);
                if(val.getBillDate()!=null){
                    vo.setBillDate(DateFormatUtil.formatDate("yyyy-MM-dd",val.getBillDate()));
                }
                switch (val.getChangeState()){
                    case 0: vo.setChangeState("未变更");break;
                    case 1: vo.setChangeState("变更中");break;
                    case 2: vo.setChangeState("已变更");break;
                };
                vo.setBillState(BillStateEnum.getEnumByStateCode(val.getBillState()).getDescription());
                voList.add(vo);
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("MasterPlan-export.xlsx", beans, response);
    }

    @ApiOperation("混泥土导出")
    @RequestMapping(value = "/excelConcreteExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelConcreteExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 计划类型隔离 */
        param.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.混泥土.getCode()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MasterPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<MasterPlanExportVO> voList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)) {
            list.forEach(val -> {
                MasterPlanExportVO vo = BeanMapper.map(val, MasterPlanExportVO.class);
                if(val.getBillDate()!=null){
                    vo.setBillDate(DateFormatUtil.formatDate("yyyy-MM-dd", val.getBillDate()));
                }
                switch (val.getChangeState()) {
                    case 0:
                        vo.setChangeState("未变更");
                        break;
                    case 1:
                        vo.setChangeState("变更中");
                        break;
                    case 2:
                        vo.setChangeState("已变更");
                        break;
                }
                ;
                vo.setBillState(BillStateEnum.getEnumByStateCode(val.getBillState()).getDescription());
                voList.add(vo);
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("ConcreteMasterPlan-export.xlsx", beans, response);
    }


    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody MasterPlanVO masterPlanVo) {
        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(masterPlanVo));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
    }
    /**
     * 目标成本推送
     * @param id
     * @return
     */
    @RequestMapping(value = "/pushTargetCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return service.pushTargetCost(id);
    }
}
