package com.ejianc.business.promaterial.pricelib.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.pricelib.bean.PriceGuideDetailEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 材料指导价子表
 * 
 * @author generator
 * 
 */
@Mapper
public interface PriceGuideDetailMapper extends BaseCrudMapper<PriceGuideDetailEntity> {

    @Select({
            "<script>",
            "SELECT d.* FROM ejc_promaterial_price_guide g,ejc_promaterial_price_guide_detail d WHERE g.id = d.guide_id AND g.bill_state in (1,3) AND g.dr = 0 AND g.flag = 0 AND d.material_id IN",
            "<foreach collection='materialList' item='materialId' open='(' separator=',' close=')'>",
            "#{materialId}",
            "</foreach>",
            "ORDER BY g.publish_date DESC",
            "</script>"
    })
    List<PriceGuideDetailEntity> queryPriceGuideDetailByMaterialIds(@Param("materialList") List<Long> materialList);
}
