package com.ejianc.business.promaterial.plan.controller.api;

import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.promaterial.plan.vo.SourceBliVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/batPlan/")
public class BatPlanApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBatPlanService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private CheckMapper checkMapper;

    @ApiOperation("引用/释放/引用完成采购计划")
    @RequestMapping(value = "/updateBatPlanQuote", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateBatPlanQuote(@RequestParam("idList") List<String> idList,
                                                     @RequestParam("planState") Integer planState,
                                                     @RequestParam("establishType") Integer establishType) {
        logger.info("修改采购计划【{}】状态为：[{}](计划状态（0-待采购；1-采购中；2-采购完成）)", idList == null ? null :
                idList.toString(), planState);
        service.updateBatPlanByQuoteType(idList, planState,establishType);
        return CommonResponse.success("操作成功！");
    }


    /**
     * 材料管理：
     * 1、累计单据数量：查该供应商在本下项目生效的  验收单、对账单、结算单数量；
     * 2、协同单据数量：查该供应商在本下项目生效的  验收单（订单）、对账单（已签字）、结算单（已签字）的数量；
     * 3、比例：协同单据数量/累计单据数量；
     */
    @GetMapping(value = "getSourceBliVO")
    public CommonResponse<List<SourceBliVO>> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId,@RequestParam(value = "dateIn",required = false) String dateIn){
        List<SourceBliVO> list = new ArrayList<>();
        List<Long> orgIds =
                iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        SourceBliVO vo= checkMapper.getSourceBliVO(supplierId,orgIds,dateIn);
        SourceBliVO concreteSourceBliVO=checkMapper.getConcreteSourceBliVO(supplierId,orgIds,dateIn);
        list.add(vo);
        list.add(concreteSourceBliVO);
        return CommonResponse.success("查询成功！",list);
    }

}
