/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.out.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.OutStoreEntity;
import com.ejianc.business.promaterial.out.service.IOutStoreService;
import com.ejianc.business.promaterial.out.vo.ExportOutStoreVO;
import com.ejianc.business.promaterial.out.vo.OutStoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outStore"})
@Api(value="\u9886\u6599\u51fa\u5e93", tags={"\u9886\u6599\u51fa\u5e93"})
public class OutStoreController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutStoreService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/outStore/card";
    private final String billTypeCode = "BT220215000000004";

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OutStoreVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(@RequestParam Long id) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.service.selectById(id));
        OutStoreVO vo = (OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutStoreVO> pushCost(@RequestBody OutStoreVO outStoreVO) {
        if (outStoreVO.getAttrFlag() != null && outStoreVO.getAttrFlag() != 2) {
            return this.service.pushCost(outStoreVO);
        }
        return CommonResponse.success((Object)outStoreVO);
    }

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u534f\u540c\u94fe\u63a5")
    @RequestMapping(value={"/getBillShareLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.service.selectById(id));
        CommonResponse supplierResp = this.proSupplierApi.whetherSupplierCoo(entity.getSubSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u4e3b\u952e-{}\u67e5\u8be2\u5931\u8d25\uff0c{}", (Object)entity.getSubSupplierId(), (Object)supplierResp.getMsg());
            return CommonResponse.error((String)"\u5355\u636e\u83b7\u53d6\u4f9b\u65b9\u4fe1\u606f\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
        }
        Boolean flag = (Boolean)supplierResp.getData();
        if (!flag.booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u672a\u5f00\u901a\u534f\u540c\u6743\u9650\uff0c\u65e0\u6cd5\u534f\u540c\u5206\u4eab\u3002");
        }
        if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode("BT220215000000004");
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)"BT220215000000004", (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            boolean pushResult = this.service.pushBillToSupCenter(entity);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushResult);
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSubSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, "BT220215000000004", entity.getSubSupplierId().toString(), "/ejc-supbusiness-mobile/#/proMaterial/outStore/card", null);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
        return this.service.del(vos);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("subSupplierName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subEmployeeName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("useFor");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutStoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("subSupplierName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subEmployeeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        ArrayList<ExportOutStoreVO> listVO = new ArrayList<ExportOutStoreVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OutStoreEntity entity : list) {
                ExportOutStoreVO storeVO = (ExportOutStoreVO)BeanMapper.map((Object)((Object)entity), ExportOutStoreVO.class);
                switch (entity.getBillState()) {
                    case 0: {
                        storeVO.setBillState("\u81ea\u7531\u6001");
                        break;
                    }
                    case 1: {
                        storeVO.setBillState("\u5df2\u63d0\u4ea4");
                        break;
                    }
                    case 2: {
                        storeVO.setBillState("\u5ba1\u6279\u4e2d");
                        break;
                    }
                    case 3: {
                        storeVO.setBillState("\u5ba1\u6279\u901a\u8fc7");
                        break;
                    }
                    case 4: {
                        storeVO.setSignStatus("\u5ba1\u6279\u9a73\u56de");
                        break;
                    }
                    case 5: {
                        storeVO.setBillState("\u5ba1\u6279\u4e2d");
                    }
                }
                if (entity.getSignStatus() != null) {
                    switch (entity.getSignStatus()) {
                        case 0: {
                            storeVO.setSignStatus("\u672a\u7b7e\u5b57");
                            break;
                        }
                        case 1: {
                            storeVO.setSignStatus("\u5df2\u7b7e\u5b57");
                        }
                    }
                }
                if (entity.getAttrFlag() != null) {
                    switch (entity.getAttrFlag()) {
                        case 1: {
                            storeVO.setSignStatus("\u81ea\u8d2d\u6750");
                            break;
                        }
                        case 2: {
                            storeVO.setSignStatus("\u7532\u4f9b\u6750");
                        }
                    }
                }
                if (entity.getOutDate() != null) {
                    storeVO.setOutDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getOutDate()));
                }
                listVO.add(storeVO);
            }
        }
        HashMap<String, ArrayList<ExportOutStoreVO>> beans = new HashMap<String, ArrayList<ExportOutStoreVO>>();
        beans.put("records", listVO);
        ExcelExport.getInstance().export("OutStore-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refOutStoreData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> refOutStoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutStoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

