/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.reconciliation.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.mapper.ReconciliationMapper;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationVO;
import com.ejianc.business.promaterial.reconciliation.vo.SupReconciliationCollectVO;
import com.ejianc.business.promaterial.reconciliation.vo.SupReconciliationDetailVO;
import com.ejianc.business.promaterial.reconciliation.vo.SupReconciliationVO;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="reconciliationService")
public class ReconciliationServiceImpl
extends BaseServiceImpl<ReconciliationMapper, ReconciliationEntity>
implements IReconciliationService {
    @Autowired
    private IAccountSettleApi accountSettleApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String OPERATE = "SETTLMENT_JS";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/reconciliation/saveReconciliation";
    private static final String XHC_BILL_TYPE = "BT220310000000001";
    private static final String HNT_BILL_TYPE = "BT220316000000003";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void updateAccount(Integer accountFlag, ReconciliationEntity entity, List<ReconciliationDetailEntity> detailList) {
        StoreApiVO storeApiVO = new StoreApiVO();
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        storeApiVO.setAccountFlag(accountFlag);
        storeApiVO.setAccountId(entity.getId());
        storeApiVO.setAccountDate(entity.getReconciliationDate());
        storeApiVO.setAccountCode(entity.getBillCode());
        for (ReconciliationDetailEntity detailEntity : detailList) {
            FlowVO flowVO = new FlowVO();
            flowVO.setAccountDetailId(detailEntity.getId());
            flowVO.setSourceId(detailEntity.getSourceId());
            flowVO.setSourceDetailId(detailEntity.getSourceDetailId());
            flowVOS.add(flowVO);
        }
        storeApiVO.setDetail(flowVOS);
        this.logger.info("\u5bf9\u8d26\u66f4\u65b0\u4fe1\u606f--" + JSONObject.toJSONString((Object)storeApiVO));
        CommonResponse response = this.accountSettleApi.changeAccountSettleByType(storeApiVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u5bf9\u8d26\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
    }

    @Override
    public void checkContract(ReconciliationEntity entity) {
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            if (CollectionUtils.isEmpty(contractDetailList)) {
                throw new BusinessException("\u5bf9\u8d26\u660e\u7ec6\u5728\u5408\u540c\u3010" + entity.getContractName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u540e\u518d\u5bf9\u8d26");
            }
            List materialIds = contractDetailList.stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).map(item -> item.getMaterialId().toString()).collect(Collectors.toList());
            List materialTypeIds = contractDetailList.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).map(item -> item.getMaterialTypeId().toString()).collect(Collectors.toList());
            for (ReconciliationDetailEntity detail : entity.getDetailList()) {
                String materialId;
                if ("del".equals(detail.getRowState())) continue;
                boolean flag = true;
                String materialTypeId = detail.getMaterialTypeId() == null ? "" : detail.getMaterialTypeId().toString();
                String string = materialId = detail.getMaterialId() == null ? "" : detail.getMaterialId().toString();
                if (materialTypeIds.contains(materialTypeId)) {
                    flag = false;
                }
                if (materialIds.contains(materialId)) {
                    flag = false;
                }
                if (!flag) continue;
                throw new BusinessException("\u6750\u6599\u3010" + detail.getMaterialName() + "\u3011\u5728\u5408\u540c\u3010" + entity.getContractName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u540e\u518d\u5bf9\u8d26");
            }
        }
    }

    @Override
    public IPage<ReconciliationVO> queryData(QueryParam param) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<ReconciliationVO> list = ((ReconciliationMapper)this.baseMapper).queryData((QueryWrapper<Object>)ReconciliationServiceImpl.changeToQueryWrapper((QueryParam)param), (IPage<ReconciliationVO>)page);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean pushBillToSupCenter(ReconciliationEntity entity, String billTypeCode) {
        String BILL_TYPE = entity.getReconciliationType() == 0 ? XHC_BILL_TYPE : HNT_BILL_TYPE;
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLMENT_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "SETTLMENT_JS");
                Boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            SupReconciliationVO supReconciliationVO = (SupReconciliationVO)BeanMapper.map((Object)((Object)entity), SupReconciliationVO.class);
            List supReconciliationDetailVOS = BeanMapper.mapList(entity.getDetailList(), SupReconciliationDetailVO.class);
            List supReconciliationCollectVOS = BeanMapper.mapList(entity.getCollectDetailList(), SupReconciliationCollectVO.class);
            supReconciliationVO.setReconciliationDetailList(supReconciliationDetailVOS);
            supReconciliationVO.setReconciliationCollectList(supReconciliationCollectVOS);
            paramMap.put("transData", JSONObject.toJSONString((Object)supReconciliationVO));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), billTypeCode, "reconciliationProjectFile", null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9644\u4ef6\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(files));
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/reconciliation/saveReconciliation", paramMap, entity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u8ba2\u5355\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLMENT_JS");
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(ReconciliationEntity entity, String billTypeCode, String url) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = billTypeCode + "::" + entity.getId().toString();
        BILL_TYPE = entity.getReconciliationType() == 0 ? "BT220310000000001" : "BT220316000000003";
        fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "reconciliationFile", null);
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.info("\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)fileResp.getData()));
            ids = ((List)fileResp.getData()).stream().map((Function<AttachmentVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/ejianc/foundation/file/vo/AttachmentVO;)Ljava/lang/Long;)()).map((Function<Long, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, valueOf(java.lang.Object ), (Ljava/lang/Long;)Ljava/lang/String;)()).collect(Collectors.joining(","));
            this.attachmentApi.delete(ids);
            entity.setSignStatus(0);
            ((ReconciliationMapper)this.baseMapper).updateById((Object)entity);
        }
        if (!(ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode()).isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLMENT_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "SETTLMENT_JS");
                var10_10 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var10_10;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSupplierId(), (Object)entity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl41
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var13_15 = supHandleResp;
                return var13_15;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl41:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLMENT_JS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        ReconciliationEntity reconciliationEntity = (ReconciliationEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String BILL_TYPE = reconciliationEntity.getReconciliationType() == 0 ? XHC_BILL_TYPE : HNT_BILL_TYPE;
        reconciliationEntity.setSupOperateTime(supOperateTime);
        reconciliationEntity.setSupOperatorName(supOperatorName);
        reconciliationEntity.setSupOperatorPhone(supOperatorPhone);
        reconciliationEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = BILL_TYPE + "::" + reconciliationEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLMENT_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)reconciliationEntity.getId());
                this.releaseLock(jedis, false, key, "SETTLMENT_JS");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, reconciliationEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            reconciliationEntity.setAttachIds(attchIdsList);
            reconciliationEntity.setSignStatus(1);
            super.saveOrUpdate((Object)reconciliationEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)reconciliationEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLMENT_JS");
        }
        return msg;
    }

    @Override
    public List<ReconciliationVO> queryCheckListByContract(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        List reconciliationEntities = super.queryList(queryParam, false);
        return BeanMapper.mapList((Iterable)reconciliationEntities, ReconciliationVO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

