package com.ejianc.business.promaterial.contract.service.impl;

import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractFreezeVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.contract.mapper.ContractFreezeMapper;
import com.ejianc.business.promaterial.contract.bean.ContractFreezeEntity;
import com.ejianc.business.promaterial.contract.service.IContractFreezeService;

import java.util.Arrays;
import java.util.List;

/**
 * 合同冻结表
 *
 * @author generator
 */
@Service("contractFreezeService")
public class ContractFreezeServiceImpl extends BaseServiceImpl<ContractFreezeMapper, ContractFreezeEntity> implements IContractFreezeService {

    /** 物资合同冻结编码 */
    private static final String BILL_CODE = "CONTRACT_FREEZE"; //CONTRACT_CONCRETE_FREEZE
    /** 混凝土冻结编码 */
    private static final String CONCRETE_BILL_CODE = "CONTRACT_CONCRETE_FREEZE"; //

    @Autowired
    private IBillCodeApi billCodeApi;
    /** 主合同信息 */
    @Autowired
    private IContractService contractService;

    @Autowired
    private IProjectSetApi projectSetApi;

    /**
     * 保存合同冻结数据
     *
     * @param saveOrUpdateVO 合同冻结
     * @return 保存结果
     */
    @Override
    public ContractFreezeVO save(ContractFreezeVO saveOrUpdateVO) {
        ContractFreezeEntity entity = BeanMapper.map(saveOrUpdateVO, ContractFreezeEntity.class);
        // 校验是否存在主合同信息
        if (null == entity.getContractId()) {
            throw new BusinessException("主合同信息为空！");
        }
        // 查询合同状态：不是履约中不可以解除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());
        if (contractEntity == null) {
            throw new BusinessException("查询不到合同！");
        }

        //成本关门后 不允许变更
        CommonResponse<ProjectPoolSetVO> projectRes = projectSetApi.getProjectId(contractEntity.getProjectId());
        if(projectRes.isSuccess()&&("16").equals(projectRes.getData().getCapitalStatus())){
            throw new BusinessException("该项目资金管控状态为【成本关门】，不允许此操作!");
        }

        if (entity.getId() == null || entity.getId() == 0) {
            String billCodeStr = BILL_CODE;
            if (MaterialContractTypeEnum.混凝土.getCode().equals(contractEntity.getContractType())) {
                billCodeStr = CONCRETE_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam
                    .build(billCodeStr, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                // 校验是否存在未生效的冻结/解冻单
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, entity.getContractId()));
                queryParam.getParams()
                        .put("performanceStatus", new Parameter(QueryParam.EQ, entity.getPerformanceStatus()));
                queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(0, 2, 4, 5)));
                List<ContractFreezeEntity> list = super.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(list)) {
                    throw new BusinessException("当前合同存在未生效的冻结/解冻单，不能再次发起！");
                }
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 合同冻结保存前校验
        contractService.checkContract(saveOrUpdateVO.getContractId(), saveOrUpdateVO.getId());
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ContractFreezeVO.class);
    }
}
