/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckDetailVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryAdmixtureEntity;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryEntity;
import com.ejianc.business.promaterial.delivery.mapper.ConcreteDeliveryMapper;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryAdmixtureService;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.ConcreteDeliveryAdmixtureVO;
import com.ejianc.business.promaterial.delivery.vo.ConcreteDeliveryDetailVO;
import com.ejianc.business.promaterial.delivery.vo.ConcreteDeliverySaveVO;
import com.ejianc.business.promaterial.delivery.vo.ConcreteDeliveryVO;
import com.ejianc.business.promaterial.delivery.vo.DeliveryTypeEnum;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderAdmixtureEntity;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderEntity;
import com.ejianc.business.promaterial.order.service.IConcreteOrderAdmixtureService;
import com.ejianc.business.promaterial.order.service.IConcreteOrderDetailService;
import com.ejianc.business.promaterial.order.service.IConcreteOrderService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.weigh.weighbill.api.IPushThirdDataApi;
import com.ejianc.business.weigh.weighbill.vo.DeliveryDetailThirdVO;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.JedisPool;

@Service(value="concreteDeliveryService")
public class ConcreteDeliveryServiceImpl
extends BaseServiceImpl<ConcreteDeliveryMapper, ConcreteDeliveryEntity>
implements IConcreteDeliveryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/concreteDelivery/saveConcreteDeliveryState";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IPushThirdDataApi pushThirdDataApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IConcreteOrderService orderService;
    @Autowired
    private IConcreteOrderDetailService concreteOrderDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IConcreteOrderAdmixtureService concreteOrderAdmixtureService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_CODE = "HNT-DELIVERY-CODE";
    private final String OPERATE = "HNT_DELIVERY_SYNC";
    private static final String BILL_TYPE_CODE = "BT220224000000003";
    @Autowired
    private IConcreteDeliveryAdmixtureService concreteDeliveryAdmixtureService;

    @Override
    public ConcreteCheckVO queryDetailToCheck(Long id) {
        List list;
        LambdaQueryWrapper wrapper;
        ConcreteDeliveryEntity deliveryEntity = (ConcreteDeliveryEntity)((Object)super.selectById((Serializable)id));
        ConcreteCheckVO checkVO = new ConcreteCheckVO();
        checkVO.setOrderId(deliveryEntity.getOrderId());
        checkVO.setDeliveryId(deliveryEntity.getId());
        checkVO.setCheckState(Integer.valueOf(0));
        checkVO.setContractId(deliveryEntity.getContractId());
        checkVO.setContractName(deliveryEntity.getContractName());
        checkVO.setContractCode(deliveryEntity.getContractCode());
        checkVO.setProjectCode(deliveryEntity.getProjectCode());
        checkVO.setProjectId(deliveryEntity.getProjectId());
        checkVO.setProjectName(deliveryEntity.getProjectName());
        checkVO.setSupplierId(deliveryEntity.getSupplierId());
        checkVO.setSupplierName(deliveryEntity.getSupplierName());
        checkVO.setDepartmentId(deliveryEntity.getDepartmentId());
        checkVO.setDepartmentName(deliveryEntity.getDepartmentName());
        checkVO.setLicensePlate(deliveryEntity.getLicensePlate());
        checkVO.setOrgId(deliveryEntity.getOrgId());
        checkVO.setOrgName(deliveryEntity.getOrgName());
        checkVO.setCheckType(deliveryEntity.getCheckType());
        checkVO.setCheckTypeName(deliveryEntity.getCheckTypeName());
        checkVO.setSourceType(Integer.valueOf(1));
        checkVO.setParentOrgId(deliveryEntity.getParentOrgId());
        checkVO.setParentOrgName(deliveryEntity.getParentOrgName());
        checkVO.setDeliveryCode(deliveryEntity.getBillCode());
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(deliveryEntity.getContractId()));
        checkVO.setPricingType(contractEntity.getPricingType());
        checkVO.setAutomaticWeigh(deliveryEntity.getAutomaticWeigh());
        checkVO.setDeliveryType(deliveryEntity.getDeliveryType());
        List<ConcreteDeliveryDetailEntity> deliveryDetailList = deliveryEntity.getConcreteDeliveryDetailList();
        List deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getDeliveryNum().compareTo(s.getCheckNum() == null ? BigDecimal.ZERO : s.getCheckNum()) == 1).collect(Collectors.toList());
        Map<Long, ContractDetailEntity> contractDetailMap = contractEntity.getContractDetailList().stream().filter(t -> null != t.getMaterialId()).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        Map<Long, ContractDetailEntity> contractDetailTypeMap = contractEntity.getContractDetailList().stream().filter(t -> null == t.getMaterialId() && null != t.getMaterialTypeId()).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        Map<Object, Object> deliveryAdmixtureMap = new HashMap();
        Map<Object, Object> orderAdmixtureMap = new HashMap();
        if (DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(deliveryEntity.getDeliveryType())) {
            wrapper = new LambdaQueryWrapper();
            wrapper.eq(ConcreteDeliveryAdmixtureEntity::getDeliveryId, (Object)deliveryEntity.getId());
            list = this.concreteDeliveryAdmixtureService.list((Wrapper)wrapper);
            deliveryAdmixtureMap = list.stream().filter(t -> null != t.getDeliveryDetailId()).collect(Collectors.groupingBy(ConcreteDeliveryAdmixtureEntity::getDeliveryDetailId));
        } else {
            wrapper = new LambdaQueryWrapper();
            wrapper.eq(ConcreteOrderAdmixtureEntity::getOrderId, (Object)deliveryEntity.getOrderId());
            list = this.concreteOrderAdmixtureService.list((Wrapper)wrapper);
            orderAdmixtureMap = list.stream().filter(t -> null != t.getDetailId()).collect(Collectors.groupingBy(ConcreteOrderAdmixtureEntity::getDetailId));
        }
        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)) {
            List<Long> materialIDS = deliveryDetailEntityList.stream().map(ConcreteDeliveryDetailEntity::getMaterialId).distinct().collect(Collectors.toList());
            List<MaterialPriceHistoryApiVO> priceHistoryApiVOS = this.priceHistoryService.getMaterialPriceHistoryApiVOS(materialIDS);
            CommonResponse commonResponse = this.shareMaterialApi.queryMaterialItemByIds(materialIDS);
            this.logger.info("\u6df7\u51dd\u571f\u9a8c\u6536id\uff1a{}\uff0c\u67e5\u8be2\u6210\u672c\u79d1\u76ee\u4fe1\u606f\uff1a{}", (Object)id, (Object)JSONObject.toJSONString((Object)commonResponse));
            Map<Object, Object> materialVOMap = new HashMap();
            if (commonResponse.isSuccess()) {
                List materialVOList = (List)commonResponse.getData();
                materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            }
            Map materialPriceMap = priceHistoryApiVOS.stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity()));
            ArrayList<ConcreteCheckDetailVO> checkDetailVOS = new ArrayList<ConcreteCheckDetailVO>();
            for (ConcreteDeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                BigDecimal rate;
                List concreteDeliveryAdmixtureEntities;
                ConcreteCheckDetailVO checkDetailVO = new ConcreteCheckDetailVO();
                checkDetailVO.setDeliveryId(deliveryEntity.getId());
                checkDetailVO.setDeliveryDetailId(deliveryDetailEntity.getId());
                checkDetailVO.setOrderId(deliveryEntity.getOrderId());
                checkDetailVO.setOrderDetailId(deliveryDetailEntity.getOrderDetailId());
                checkDetailVO.setMaterialId(deliveryDetailEntity.getMaterialId());
                checkDetailVO.setMaterialName(deliveryDetailEntity.getMaterialName());
                checkDetailVO.setMaterialTypeId(deliveryDetailEntity.getMaterialTypeId());
                checkDetailVO.setMaterialTypeName(deliveryDetailEntity.getMaterialTypeName());
                checkDetailVO.setMaterialCode(deliveryDetailEntity.getMaterialCode());
                checkDetailVO.setUnit(deliveryDetailEntity.getUnit());
                checkDetailVO.setUnitId(deliveryDetailEntity.getUnitId());
                checkDetailVO.setSpec(deliveryDetailEntity.getSpec());
                checkDetailVO.setDeliverNum(deliveryDetailEntity.getDeliveryNum());
                checkDetailVO.setAdmixtureId(deliveryDetailEntity.getAdmixtureId());
                checkDetailVO.setAdmixtureName(deliveryDetailEntity.getAdmixtureName());
                checkDetailVO.setDetailAutomaticWeigh(deliveryDetailEntity.getDetailAutomaticWeigh());
                checkDetailVO.setCheckNum(deliveryDetailEntity.getDeliveryNum().subtract(deliveryDetailEntity.getCheckNum() == null ? BigDecimal.ZERO : deliveryDetailEntity.getCheckNum()));
                checkDetailVO.setSourceId(deliveryDetailEntity.getSourceDetailId());
                if (deliveryDetailEntity.getMaterialId() != null && materialPriceMap.containsKey(deliveryDetailEntity.getMaterialId())) {
                    checkDetailVO.setHistoryPriceArea(((MaterialPriceHistoryApiVO)materialPriceMap.get(deliveryDetailEntity.getMaterialId())).getHistoryPriceArea());
                    checkDetailVO.setHistoryTaxPriceArea(((MaterialPriceHistoryApiVO)materialPriceMap.get(deliveryDetailEntity.getMaterialId())).getHistoryTaxPriceArea());
                }
                if (deliveryDetailEntity.getMaterialId() != null && materialVOMap.containsKey(checkDetailVO.getMaterialId())) {
                    MaterialVO materialVO = (MaterialVO)materialVOMap.get(checkDetailVO.getMaterialId());
                    checkDetailVO.setSubjectId(materialVO.getSubjectId());
                    checkDetailVO.setSubjectName(materialVO.getSubjectName());
                }
                BigDecimal admixturePrice = BigDecimal.ZERO;
                BigDecimal taxPrice = BigDecimal.ZERO;
                BigDecimal price = BigDecimal.ZERO;
                ContractDetailEntity contractDetailEntity = contractDetailMap.get(checkDetailVO.getMaterialId());
                ContractDetailEntity contractDetailTypeEntity = contractDetailTypeMap.get(checkDetailVO.getMaterialTypeId());
                if (null != contractDetailEntity) {
                    concreteDeliveryAdmixtureEntities = (List)deliveryAdmixtureMap.get(checkDetailVO.getDeliveryDetailId());
                    if (CollectionUtils.isNotEmpty((Collection)concreteDeliveryAdmixtureEntities)) {
                        admixturePrice = concreteDeliveryAdmixtureEntities.stream().filter(e -> e.getPrice() != null).map(ConcreteDeliveryAdmixtureEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    rate = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeAdd((BigDecimal)new BigDecimal("100"), (BigDecimal)contractDetailEntity.getDetailTaxRate()), (BigDecimal)new BigDecimal("100"));
                    taxPrice = ComputeUtil.safeAdd((BigDecimal)contractDetailEntity.getDetailTaxPrice(), (BigDecimal)admixturePrice);
                    price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)rate);
                    checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                    checkDetailVO.setCheckPrice(price);
                    checkDetailVO.setCheckTaxPrice(taxPrice);
                    checkDetailVO.setMemo(contractDetailEntity.getMemo());
                    checkDetailVO.setContractFlag(Integer.valueOf(1));
                } else if (null != contractDetailTypeEntity) {
                    concreteDeliveryAdmixtureEntities = (List)deliveryAdmixtureMap.get(checkDetailVO.getDeliveryDetailId());
                    if (CollectionUtils.isNotEmpty((Collection)concreteDeliveryAdmixtureEntities)) {
                        admixturePrice = concreteDeliveryAdmixtureEntities.stream().filter(e -> e.getPrice() != null).map(ConcreteDeliveryAdmixtureEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    rate = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeAdd((BigDecimal)new BigDecimal("100"), (BigDecimal)contractDetailTypeEntity.getDetailTaxRate()), (BigDecimal)new BigDecimal("100"));
                    taxPrice = ComputeUtil.safeAdd((BigDecimal)contractDetailTypeEntity.getDetailTaxPrice(), (BigDecimal)admixturePrice);
                    price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)rate);
                    checkDetailVO.setTaxRate(contractDetailTypeEntity.getDetailTaxRate());
                    checkDetailVO.setCheckPrice(price);
                    checkDetailVO.setCheckTaxPrice(taxPrice);
                    checkDetailVO.setMemo(contractDetailTypeEntity.getMemo());
                    checkDetailVO.setContractFlag(Integer.valueOf(1));
                } else {
                    checkDetailVO.setContractFlag(Integer.valueOf(2));
                }
                checkDetailVOS.add(checkDetailVO);
            }
            checkVO.setConcreteCheckDetailList(checkDetailVOS);
        }
        return checkVO;
    }

    @Override
    public ConcreteDeliveryVO closeDelivery(Long id) {
        ConcreteDeliveryEntity concreteDeliveryEntity = (ConcreteDeliveryEntity)((Object)super.selectById((Serializable)id));
        concreteDeliveryEntity.setCloseFlag(1);
        super.updateById((Object)concreteDeliveryEntity);
        if (DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(concreteDeliveryEntity.getDeliveryType())) {
            return (ConcreteDeliveryVO)BeanMapper.map((Object)((Object)concreteDeliveryEntity), ConcreteDeliveryVO.class);
        }
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", concreteDeliveryEntity.getSourceId());
        map.put("closeFlag", 1);
        map.put("systemId", ejcCloudSystemCode.getData());
        String dataInfo = JSONObject.toJSONString(map);
        Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(concreteDeliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/concreteDelivery/saveConcreteDeliveryState", RequestMethod.POST, concreteDeliveryEntity.getSupplierId().toString(), "HNT_DELIVERY_SYNC", BILL_TYPE_CODE);
        if (!updateSupplierStatus.booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
        }
        return (ConcreteDeliveryVO)BeanMapper.map((Object)((Object)concreteDeliveryEntity), ConcreteDeliveryVO.class);
    }

    @Override
    public ConcreteDeliveryVO saveOrUpdates(ConcreteDeliveryVO saveOrUpdateVO) {
        ConcreteDeliveryEntity entity = (ConcreteDeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ConcreteDeliveryEntity.class));
        List materialDeliveryDetailList = saveOrUpdateVO.getConcreteDeliveryDetailList();
        List deliveryDetailEntityList = BeanMapper.mapList((Iterable)materialDeliveryDetailList, ConcreteDeliveryDetailEntity.class);
        entity.setConcreteDeliveryDetailList(deliveryDetailEntityList);
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setCloseFlag(0);
        entity.setSourceType(1);
        entity.setDeliveryType(2);
        super.saveOrUpdate((Object)entity, false);
        if (null != entity.getAutomaticWeigh() && 0 == entity.getAutomaticWeigh()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(entity.getContractId()));
            ConcreteOrderEntity orderEntity = (ConcreteOrderEntity)((Object)this.orderService.getById(entity.getOrderId()));
            DeliveryThirdVO thirdVO = (DeliveryThirdVO)BeanMapper.map((Object)((Object)entity), DeliveryThirdVO.class);
            thirdVO.setEmployeeName(orderEntity.getEmployeeName() == null ? orderEntity.getCreateUserCode() : orderEntity.getEmployeeName());
            thirdVO.setOrderAddress(orderEntity.getOrderAddress());
            thirdVO.setCustomerId(contractEntity.getCustomerId());
            thirdVO.setCustomerName(contractEntity.getCustomerName());
            thirdVO.setDeliverType("HNT");
            List<ConcreteDeliveryDetailEntity> detailList = entity.getConcreteDeliveryDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                thirdVO.setDetailList(BeanMapper.mapList(detailList, DeliveryDetailThirdVO.class));
            }
            this.logger.info("\u6df7\u51dd\u571f\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u53c2\u6570----\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdVO));
            CommonResponse thirdRes = this.pushThirdDataApi.pushThirdData(thirdVO);
            if (!thirdRes.isSuccess()) {
                this.logger.info("\u6df7\u51dd\u571f\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                entity.setIsPushThird("unSucPush");
                entity.setUnSucReason(thirdRes.getMsg());
            } else {
                this.logger.info("\u6df7\u51dd\u571f\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                entity.setIsPushThird("sucPushed");
            }
            super.updateById((Object)entity);
        }
        ConcreteDeliveryVO vo = (ConcreteDeliveryVO)BeanMapper.map((Object)((Object)entity), ConcreteDeliveryVO.class);
        return vo;
    }

    @Override
    public ConcreteDeliveryVO savePushThirdData(Long id) {
        ConcreteDeliveryEntity entity = (ConcreteDeliveryEntity)((Object)super.selectById((Serializable)id));
        if (null != entity.getAutomaticWeigh() && 0 == entity.getAutomaticWeigh()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.getById(entity.getContractId()));
            DeliveryThirdVO thirdVO = (DeliveryThirdVO)BeanMapper.map((Object)((Object)entity), DeliveryThirdVO.class);
            if (DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(entity.getDeliveryType())) {
                thirdVO.setOrderAddress("/");
            } else {
                ConcreteOrderEntity orderEntity = (ConcreteOrderEntity)((Object)this.orderService.getById(entity.getOrderId()));
                thirdVO.setEmployeeName(orderEntity.getEmployeeName() == null ? orderEntity.getCreateUserCode() : orderEntity.getEmployeeName());
                thirdVO.setOrderAddress(orderEntity.getOrderAddress());
            }
            thirdVO.setCustomerId(contractEntity.getCustomerId());
            thirdVO.setCustomerName(contractEntity.getCustomerName());
            thirdVO.setDeliverType("HNT");
            List<ConcreteDeliveryDetailEntity> detailList = entity.getConcreteDeliveryDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                thirdVO.setDetailList(BeanMapper.mapList(detailList, DeliveryDetailThirdVO.class));
            }
            this.logger.info("\u6df7\u51dd\u571f\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e\u53c2\u6570----\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdVO));
            CommonResponse thirdRes = this.pushThirdDataApi.pushThirdData(thirdVO);
            if (thirdRes.isSuccess()) {
                this.logger.info("\u6df7\u51dd\u571f\u63a8\u9001\u7b2c\u4e09\u65b9\u6570\u636e----\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)thirdRes.getMsg()));
                entity.setIsPushThird("sucPushed");
            } else {
                entity.setUnSucReason(thirdRes.getMsg());
            }
            super.updateById((Object)entity);
        }
        ConcreteDeliveryVO vo = (ConcreteDeliveryVO)BeanMapper.map((Object)((Object)entity), ConcreteDeliveryVO.class);
        return vo;
    }

    @Override
    public ConcreteDeliverySaveVO saveOrUpdate(ConcreteDeliverySaveVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            saveOrUpdateVO.setBillCode((String)billCode.getData());
            saveOrUpdateVO.setId(Long.valueOf(IdWorker.getId()));
        }
        List concreteDeliveryDetailList = saveOrUpdateVO.getConcreteDeliveryDetailList();
        ArrayList<ConcreteDeliveryAdmixtureEntity> admixtureArrayList = new ArrayList<ConcreteDeliveryAdmixtureEntity>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)concreteDeliveryDetailList)) {
            for (ConcreteDeliveryDetailVO concreteDeliveryDetailVO : concreteDeliveryDetailList) {
                List admixtureVOList;
                if (concreteDeliveryDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    concreteDeliveryDetailVO.setId(Long.valueOf(id));
                }
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(admixtureVOList = concreteDeliveryDetailVO.getAdmixtureVOList()))) continue;
                for (ConcreteDeliveryAdmixtureVO concreteDeliveryAdmixtureVO : admixtureVOList) {
                    concreteDeliveryAdmixtureVO.setDeliveryDetailId(concreteDeliveryDetailVO.getId());
                    ConcreteDeliveryAdmixtureEntity concreteDeliveryAdmixtureEntity = (ConcreteDeliveryAdmixtureEntity)((Object)BeanMapper.map((Object)concreteDeliveryAdmixtureVO, ConcreteDeliveryAdmixtureEntity.class));
                    concreteDeliveryAdmixtureEntity.setId(null);
                    concreteDeliveryAdmixtureEntity.setDeliveryId(saveOrUpdateVO.getId());
                    admixtureArrayList.add(concreteDeliveryAdmixtureEntity);
                }
            }
        }
        List ids = concreteDeliveryDetailList.stream().map(BaseVO::getId).collect(Collectors.toList());
        saveOrUpdateVO.setConcreteDeliveryAdmixtureList(null);
        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(ConcreteDeliveryAdmixtureEntity::getDeliveryDetailId, ids);
            this.concreteDeliveryAdmixtureService.remove((Wrapper)wrapper, false);
        }
        if (CollectionUtils.isNotEmpty(admixtureArrayList)) {
            this.concreteDeliveryAdmixtureService.saveBatch(admixtureArrayList);
        }
        ConcreteDeliveryEntity entity = (ConcreteDeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ConcreteDeliveryEntity.class));
        super.saveOrUpdate((Object)entity, false);
        ConcreteDeliverySaveVO vo = (ConcreteDeliverySaveVO)BeanMapper.map((Object)((Object)entity), ConcreteDeliverySaveVO.class);
        return this.queryDetail(vo.getId());
    }

    @Override
    public ConcreteDeliverySaveVO queryDetail(Long id) {
        ConcreteDeliveryEntity entity = (ConcreteDeliveryEntity)((Object)super.selectById((Serializable)id));
        ConcreteDeliverySaveVO vo = (ConcreteDeliverySaveVO)BeanMapper.map((Object)((Object)entity), ConcreteDeliverySaveVO.class);
        List concreteDeliveryDetailList = vo.getConcreteDeliveryDetailList();
        List concreteDeliveryAdmixtureList = vo.getConcreteDeliveryAdmixtureList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)concreteDeliveryAdmixtureList)) {
            Map<Long, List<ConcreteDeliveryAdmixtureVO>> bidderMap = concreteDeliveryAdmixtureList.stream().collect(Collectors.groupingBy(ConcreteDeliveryAdmixtureVO::getDeliveryDetailId));
            if (CollectionUtils.isNotEmpty((Collection)concreteDeliveryDetailList)) {
                for (ConcreteDeliveryDetailVO concreteDeliveryDetailVO : concreteDeliveryDetailList) {
                    List<ConcreteDeliveryAdmixtureVO> admixtureVOList = bidderMap.get(concreteDeliveryDetailVO.getId());
                    if (!CollectionUtils.isNotEmpty(admixtureVOList)) continue;
                    concreteDeliveryDetailVO.setAdmixtureVOList(admixtureVOList);
                }
            }
        }
        return vo;
    }
}

