package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.bean.*;
import com.ejianc.business.promaterial.contract.enums.*;
import com.ejianc.business.promaterial.contract.service.*;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.*;

@Service("contractChange") 
public class ContractChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IContractService contractService;
	@Autowired
	private IParamConfigApi paramConfigApi;
	@Autowired
	ISignatureCommonApi signatureCommonApi;
	@Autowired
	private IContractChangeAsyncService contractChangeAsyncService;
	@Autowired
	private IContractChangeService contractChangeService;
	@Autowired
	private IProjectPoolApi projectPoolApi;


	private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("进入审批同意后回写--- billId:"+billId+"  state:"+state);
		/**更新变更的审批时间  begin */
		ContractChangeEntity changeEntity = contractChangeService.selectById(billId);

		Boolean commitState = false;
		if (DraftTypeEnum.线下签订.getCode().toString().equals(changeEntity.getChangeDraftType())){
			//调用生效回写服务
			CommonResponse<String> rsp = contractChangeService.effectiveSaveWriteContract(billId, billTypeCode, commitState, false);
			if (!rsp.isSuccess()) {
				throw new BusinessException("审批回写失败!失败原因：" + rsp.getMsg());
			}
		}
		else {
			//回写主合同信息
			ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
			contractEntity.setChangeStatus(ChangeStatusEnum.变更单据审批通过.getCode());
			contractService.saveOrUpdate(contractEntity, false);
			logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));
		}
		contractChangeService.asyncWatermarkById(billId);


		return CommonResponse.success("审批回调合同成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ContractChangeEntity contractChangeEntity = contractChangeService.selectById(billId);
//		if (!PerformanceStatusEnum.未签订.getCode().equals(contractChangeEntity.getPerformanceStatus())) {
////			return CommonResponse.error("合同变更单暂不支持回退功能!");
//			return CommonResponse.error("合同变更已生效，不能撤回!");
//		}
//		return CommonResponse.error("合同变更已生效，不能撤回!");
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());

		//使用电子签章且已有签章流程则不允许撤回
		if (!DraftTypeEnum.线下签订.getCode().toString().equals(contractChangeEntity.getChangeDraftType())
				&& !statusList.contains(contractChangeEntity.getSignatureStatus())) {
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}
//		else if (SignatureStatusEnum.已签章.getCode().equals(contractChangeEntity.getSignatureStatus())) {
//			contractChangeEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
//		}
		// 合同变更 线下签订不适用电子签章，已生效的不允许撤回
		if (DraftTypeEnum.线下签订.getCode().toString().equals(contractChangeEntity.getChangeDraftType())
				&& SignatureStatusEnum.已签章.getCode().equals(contractChangeEntity.getSignatureStatus())) {
			return CommonResponse.error("合同变更已生效，不能撤回!");
		}
		if (SignatureStatusEnum.已签章.getCode().equals(contractChangeEntity.getSignatureStatus())) {
			contractChangeEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
		}
		contractChangeEntity.setCommitDate(null);
		contractChangeEntity.setCommitUserCode(null);
		contractChangeEntity.setCommitUserName(null);
		contractChangeService.saveOrUpdate(contractChangeEntity);
		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractChangeEntity));

		ContractEntity contractEntity = contractService.selectById(contractChangeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		contractService.saveOrUpdate(contractEntity, false);

		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		// 更新合同池数据的累计变更金额（含税、无税、税额）、累计变更比例
		ContractChangeEntity contractChangeEntity = contractChangeService.selectById(billId);
		contractChangeService.updateTotalChangeDataByContractId(contractChangeEntity, "back");
		return CommonResponse.success();
	}


	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			ContractChangeEntity entity = contractChangeService.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
