package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.bean.ContractRelieveEntity;
import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;

@Service("batPlan")
public class BatPlanBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String SIGN = "plan";

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IBatPlanService batPlanService;

	@Autowired
	private IProjectPoolApi projectPoolApi;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	;

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		logger.info("------------撤回前回调------------");
		logger.info("billId:{},state:{},billTypeCode:{}",billId,state,billTypeCode);
		BatPlanEntity batPlanEntity = batPlanService.selectById(billId);
		// 如果是待采购，则不判断是否引用
		if (BatPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(batPlanEntity.getPlanState())) {
			return CommonResponse.success();
		}
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("检查结果：{}",resp);
		if (!resp.isSuccess()) {
//			return CommonResponse.error("无法撤回！" + resp.getMsg());
			return CommonResponse.error("单据被引用不能撤回！");
		}
		return CommonResponse.success();
	}

	;

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	;

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		logger.info("-------------------审批前回调------------------------");
		logger.info("sign-->>{}", sign);
		if (SIGN.equals(sign)) {
			BatPlanEntity batPlanEntity = batPlanService.selectById(billId);
			// 招标经办人不能为空
			if (batPlanEntity == null || batPlanEntity.getTrusteesId() == null){
				return CommonResponse.error("请先选择招标经办人！");
			}
		}
		return CommonResponse.success();
	}

	;

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("-------------------终审审核前回调------------------------");
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		logger.info("------------弃审前事件回调------------");
		logger.info("弃审前事件回调===billId:{},state:{},billTypeCode:{}",billId,state,billTypeCode);
		BatPlanEntity batPlanEntity = batPlanService.selectById(billId);
		// 如果是待采购，则不判断是否引用
		if (BatPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(batPlanEntity.getPlanState())) {
			return CommonResponse.success();
		}
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("检查结果：{}",resp);
		if (!resp.isSuccess()) {
//			return CommonResponse.error("无法撤回！" + resp.getMsg());
			return CommonResponse.error("单据被引用不能撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			BatPlanEntity entity = batPlanService.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}


}
