package com.ejianc.business.promaterial.order.service.impl;

import com.ejianc.business.promaterial.order.bean.ConcreteOrderEntity;
import com.ejianc.business.promaterial.order.service.IConcreteOrderService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

@Service("concreteOrder") 
public class ConcreteOrderBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private IConcreteOrderService concreteOrderService;

	private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/concreteOrder/deleteOrder";


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ConcreteOrderEntity orderEntity = concreteOrderService.selectById(billId);
		orderEntity.setCommitId(InvocationInfoProxy.getUserid());
		concreteOrderService.saveOrUpdate(orderEntity,false);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ConcreteOrderEntity orderEntity = concreteOrderService.selectById(billId);
		//推送供方
		Boolean pushFlag = concreteOrderService.pushBillToSupCenter(orderEntity,billTypeCode);
		logger.info("获取推送供方结果--"+pushFlag);
		if(pushFlag){
			//推送成功后处理逻辑
			if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state){
				orderEntity.setCommitId(InvocationInfoProxy.getUserid());
			}
			orderEntity.setReceiveState(0);
			concreteOrderService.saveOrUpdate(orderEntity,false);
		}else{
			return CommonResponse.error("推送供方失败");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ConcreteOrderEntity orderEntity = concreteOrderService.selectById(billId);
		if(orderEntity.getReceiveState()==0){
			return CommonResponse.success();
		}else{
			return CommonResponse.error("该订单已被下游操作，不允许回退!");
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ConcreteOrderEntity orderEntity = concreteOrderService.selectById(billId);
		return concreteOrderService.updatePushBill(orderEntity,billTypeCode,DEL_BILL_SERVER_URL);
	}
}
