package com.ejianc.business.promaterial.plan.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.promaterial.plan.bean.BatPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.promaterial.plan.service.IBatPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanVO;
import com.ejianc.business.tender.api.ITenderCostApi;
import com.ejianc.business.tender.cost.vo.PlanControlRuleDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料批次采购计划主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("batPlan")
@Api(value = "材料批次采购计划主表", tags = {"材料批次采购计划主表"})
public class BatPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PARCEL_PLAN_CODE";//此处需要根据实际修改

    @Autowired
    private IBatPlanService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITenderCostApi tenderCostApi;
    @Autowired
    private IBatPlanDetailService batPlanDetailService;



    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BatPlanVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody BatPlanVO saveorUpdateVO) {
        BatPlanVO vo = service.saveOrUpdateByVo(saveorUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BatPlanVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryBatPlanDetailById(id));
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BatPlanVO> vos) {
//        if(ListUtil.isNotEmpty(vos)){
//            for (OutStoreVO vo : vos) {
//                // 参数是单据类型编码字符串 根据需求是否打开下面代码
//                /**CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                    return CommonResponse.error("删除失败！"+resp.getMsg());
//                }*/
//            }
//        }
        List<Long> collect = vos.stream().map(BatPlanVO::getId).collect(Collectors.toList());


        //中间库删除
        QueryWrapper<BatPlanDetailEntity> batPlanDetailEntityQueryWrapper = new QueryWrapper<>();
        batPlanDetailEntityQueryWrapper.in("plan_id",collect);
        List<BatPlanDetailEntity> list = batPlanDetailService.list(batPlanDetailEntityQueryWrapper);
        List<BatPlanDetailVO> batPlanDetailVOS = BeanMapper.mapList(list, BatPlanDetailVO.class);
        tenderCostApi.delete(batPlanDetailVOS);

        service.removeByIds(collect,true);

        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BatPlanVO>> queryList(@RequestBody QueryParam param) {
        IPage<BatPlanVO> pageData = service.queryBatPlanPage(param);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<BatPlanVO> list = service.excelExportBatPlan(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BatPlan-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refBatPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BatPlanVO>> refBatPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        // searchObject做模糊匹配处理
//        param.setSearchObject(searchObject);
        IPage<BatPlanVO> pageData = service.refBatPlanData(param, condition, searchObject);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("采购类别下拉参照")
    @RequestMapping(value = "/refPurchaseDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String,List<DefdocDetailVO>>> refPurchaseDate() {
        // searchObject做模糊匹配处理
//        param.setSearchObject(searchObject);
        List<DefdocDetailVO> pageData = service.refPurchaseDate();
        Map<String,List<DefdocDetailVO>> map = new HashMap<>();
        map.put("data",pageData);
        return CommonResponse.success("查询参照数据成功！", map);
    }
    @ApiOperation("查询招标待办")
    @RequestMapping(value = "/tenderPending", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BatPlanVO>> tenderPending() {
        QueryWrapper<BatPlanEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("trustees_id",sessionManager.getUserContext().getEmployeeId())
                .eq("plan_state",0)
                .eq("tenant_id",InvocationInfoProxy.getTenantid())
                .in("bill_state", Arrays.asList(1,3))
                .orderByDesc("create_time");

        // 数据隔离 本下 没有组织orgId的删除下面代码 */
        CommonResponse<List<OrgVO>> orgResponse = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("查询失败，获取组织信息失败！");
        }
        List<OrgVO> orgVOList = orgResponse.getData();
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            }
            else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        // 查询本下
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            // 要求主表有orgId字段，保存单据所属组织
            wrapper.in("parent_org_id", commonOrgIds);
        }
        // 查询项目部
        else if (CollectionUtils.isNotEmpty(departmentIds)) {
            // 要求主表有parentOrgId字段，保存单据所属项目部
            wrapper.in("org_id",departmentIds);
        }
        List<BatPlanVO> voList = BeanMapper.mapList(service.list(wrapper), BatPlanVO.class);
        return CommonResponse.success("查询数据成功！",voList);
    }


    @ApiOperation("提交前校验目标责任成本")
    @RequestMapping(value = "/check", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PlanControlRuleDetailVO>> check(@RequestParam Long id) {
        BatPlanEntity batPlanEntity = service.selectById(id);
        BatPlanVO batPlanVO = BeanMapper.map(batPlanEntity, BatPlanVO.class);
        CommonResponse<List<PlanControlRuleDetailVO>> check = tenderCostApi.check(batPlanVO);
        if (check.getCode() == 0) {
            List<PlanControlRuleDetailVO> data = check.getData();
            return CommonResponse.success("查询计划管控数据成功！",data );
        }else {
            return CommonResponse.error("查询计划管控数据失败！");
        }
    }
}
