package com.ejianc.business.promaterial.reconciliation.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Service("reconciliation") 
public class ReconciliationBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IReconciliationService service;
	private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/reconciliation/delReconciliation";
	private Logger logger = LoggerFactory.getLogger(this.getClass());


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
			//推送供方
			ReconciliationEntity entity = service.selectById(billId);
			Boolean pushFlag = service.pushBillToSupCenter(entity,billTypeCode);
//			logger.info("获取推送供方结果--"+pushFlag);
			if(!pushFlag){
				//推送成功后处理逻辑
				entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			}else{
				entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
			}
			service.updateById(entity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//对账单是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}
		ReconciliationEntity entity = service.selectById(billId);
		List<ReconciliationEntity> list =service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", entity.getContractId()).in("bill_state",0,2,4,5).eq("dr", 0).ne("id",entity.getId()));
		if (list.size()>0){
			throw new BusinessException("合同下存在一张未生效的对账单");
		}
		if (entity.getSignStatus()==1){
			throw new BusinessException("已签字不能撤回");
		}
		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())){
			CommonResponse<String> commonResponse = service.updatePushBill(entity,billTypeCode,DEL_BILL_SERVER_URL);
			logger.info("供方结果"+ JSONObject.toJSONString(commonResponse));
			if(!commonResponse.isSuccess()){
				return CommonResponse.error("弃审推送供方失败,错误信息："+commonResponse.getMsg());
			}
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			service.updateById(entity);
			logger.info("供方撤回成功---"+JSONObject.toJSONString(entity));
		}
		return CommonResponse.success();
	}

}
