package com.ejianc.business.proother.settle.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 结算实体
 *
 * @author generator
 *
 */
public class SettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @ConvertField(targetField = "billCode")
    private String billCode; // 单据编码
    @ConvertField(targetField = "billState")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String commitUserCode; // 提交人账号
    private String commitUserName; // 提交人名称
    private Date commitDate; // 提交日期
    private Date effectiveDate; // 生效日期
    @ConvertField(targetField = "orgId")
    private Long orgId; // 项目部id
    @ConvertField(targetField = "orgCode")
    private String orgCode; // 项目部编码
    @ConvertField(targetField = "orgName")
    private String orgName; // 项目部名称
    @ConvertField(targetField = "parentOrgId")
    private Long parentOrgId; // 项目部所属组织id
    @ConvertField(targetField = "parentOrgCode")
    private String parentOrgCode; // 项目部所属组织编码
    @ConvertField(targetField = "parentOrgName")
    private String parentOrgName; // 项目部所属组织名称
    private Long contractCategoryId; // 合同类别
    private String contractCategoryName; // 合同类别名称
    @ConvertField(targetField = "contractId")
    private Long contractId; // 合同id
    @ConvertField(targetField = "contractName")
    private String contractName; // 合同名称
    @ConvertField(targetField = "contractCode")
    private String contractCode; // 合同编码
    @ConvertField(targetField = "supplementFlag")
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    @ConvertField(targetField = "projectId")
    private Long projectId; // 项目Id
    @ConvertField(targetField = "projectName")
    private String projectName; // 项目名称
    @ConvertField(targetField = "projectCode")
    private String projectCode; // 项目编号

    @ConvertField(targetField = "settleDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    @ConvertField(targetField = "employeeId")
    private Long employeeId; // 经办人id
    @ConvertField(targetField = "employeeName")
    private String employeeName; // 经办人名称
    @ConvertField(targetField = "departmentId")
    private Long departmentId; // 经办部门id
    @ConvertField(targetField = "departmentName")
    private String departmentName; // 经办部门名称
    @ConvertField(targetField = "memo")
    private String memo; // 非必填，0-300字
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal taxMny; // 本期结算金额
    @ConvertField(targetField = "curMny")
    private BigDecimal mny; // 本期结算金额(无税)
    @ConvertField(targetField = "curTax")
    private BigDecimal tax; // 本期结算税额
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额(无税)
    private BigDecimal taxRate; // 税率
    private BigDecimal lastTaxMny; // 已结算金额
    private BigDecimal lastMny; // 已结算金额(无税)
    private BigDecimal lastTax; // 已结算税额
    private BigDecimal totalTaxMny; // 含本期结算金额
    private BigDecimal totalMny; // 含本期结算金额(无税)
    private BigDecimal settleScale; // 已结算比例
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 供应商
    @ConvertField(targetField = "partybName")
    private String supplierName; // 供应商（名称）乙方
    private Integer settleType; // 结算类型：0-过程，1-完工
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date minSettleDate; //最小可用结算日期
    private String settleTypeStr;
    @ConvertField(targetField = "billStateName")
    private String billStateName; // 单据状态名称
    private BigDecimal totalSettleScale; // 累计 结算比例
    private String totalSettleScaleStr; // 累计 结算比例展示

    @ConvertField(targetField = "sourceId,id")
    private Long id;

    @ConvertField
    private Integer dr;
    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String billPushFlag;
    private BigDecimal TotalSettleScale; //含本期已结算比例

    private Integer settleTimes; // 累计结算次数

    /**
     * 推送结算池标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    private String pushPoolFlag;

    /**
     * 明细实体
     */
    private List<SettleDetailVO> detailList = new ArrayList<>();

    /**
     * 其他费用实体
     */
    private List<SettleOtherVO> otherList = new ArrayList<>();

    private String relationFlag; // 关联状态(1:是，0：否)

    @ConvertField
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @ConvertField
    private Integer filingStatus;//是否归档 1：是；0：否 2：归档中

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }
    public Integer getSettleTimes() {
        return settleTimes;
    }

    public void setSettleTimes(Integer settleTimes) {
        this.settleTimes = settleTimes;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }



    public Date getMinSettleDate() {
        return minSettleDate;
    }

    public String getSettleTypeStr() {
        return settleTypeStr;
    }

    public BigDecimal getTotalSettleScale() {
        return totalSettleScale;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public void setTotalSettleScale(BigDecimal totalSettleScale) {
        this.totalSettleScale = totalSettleScale;
    }

    public String getTotalSettleScaleStr() {
        return totalSettleScaleStr;
    }

    public void setTotalSettleScaleStr(String totalSettleScaleStr) {
        this.totalSettleScaleStr = totalSettleScaleStr;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public void setSettleTypeStr(String settleTypeStr) {
        this.settleTypeStr = settleTypeStr;
    }

    public void setMinSettleDate(Date minSettleDate) {
        this.minSettleDate = minSettleDate;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }




    public List<SettleDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SettleDetailVO> detailList) {
        this.detailList = detailList;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public List<SettleOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<SettleOtherVO> otherList) {
        this.otherList = otherList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getLastTaxMny() {
        return lastTaxMny;
    }

    public void setLastTaxMny(BigDecimal lastTaxMny) {
        this.lastTaxMny = lastTaxMny;
    }
    public BigDecimal getLastMny() {
        return lastMny;
    }

    public void setLastMny(BigDecimal lastMny) {
        this.lastMny = lastMny;
    }
    public BigDecimal getLastTax() {
        return lastTax;
    }

    public void setLastTax(BigDecimal lastTax) {
        this.lastTax = lastTax;
    }
    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public BigDecimal getSettleScale() {
        return settleScale;
    }

    public void setSettleScale(BigDecimal settleScale) {
        this.settleScale = settleScale;
    }

}
