package com.ejianc.business.proother.settle.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 完工类型状态
 */
public enum SettleTypeEnum {

    /**
     * 过程
     */
    过程(0, "过程"),

    /**
     * 完工
     */
    完工(1, "完工"),

    /**
     * 节点
     */
    节点(2, "节点");

    private Integer code;
    private String description;
    private static Map<Integer, SettleTypeEnum> enumMap = new HashMap<>();

    SettleTypeEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }

    static {
        enumMap = (Map) EnumSet.allOf(SettleTypeEnum.class).stream().collect(Collectors.toMap(SettleTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

    public static SettleTypeEnum getDescriptionByCode(Integer code) {
        return (SettleTypeEnum)enumMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Map<Integer, SettleTypeEnum> getEnumMap() {
        return enumMap;
    }

    public static void setEnumMap(Map<Integer, SettleTypeEnum> enumMap) {
        SettleTypeEnum.enumMap = enumMap;
    }
}
