package com.ejianc.business.proother.contract.vo;

import com.ejianc.business.proother.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 分包变更明细
 *
 * @author generator
 * 
 */
public class ChangeDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;


    /**
     * 清单编号
     */
    private String detailCode;

    /**
     * 清单名称
     */
    private String detailName;

    /**
     * 序号
     */
    private String treeIndex;

    /**
     * 工作内容
     */
    private String detailWorkContent;

    /**
     * 计量规则
     */
    private String detailMeasurementRules;

    /**
     * 单位
     */
    private String detailUnit;

    /**
     * 工程量
     */
    private BigDecimal detailNum;

    /**
     * 单价（无税）
     */
    private BigDecimal detailPrice;

    /**
     * 税率
     */
    private BigDecimal detailTaxRate;

    /**
     * 金额（无税）
     */
    private BigDecimal detailMny;

    /**
     * 单价(含税）
     */
    private BigDecimal detailTaxPrice;

    /**
     * 金额（含税）
     */
    private BigDecimal detailTaxMny;

    /**
     * 税额
     */
    private BigDecimal detailTax;

    /**
     * 备注
     */
    private String detailMemo;

    /**
     * 来源数据Id
     */
    private Long sourceId;

    /**
     * 来源类型：1-定标结果带入
     */
    private String sourceType;


    /**
     * 变更主键
     */
    private Long changeId;


    /**
     * 来源子表主键
     */
    private Long srcTblId;

    /**
     * 变更前数量
     */
    private BigDecimal beforeChangeNum;

    /**
     * 变更前价格(无税单价)
     */
    private BigDecimal beforeChangePrice;

    /**
     * 变更前税率
     */
    private BigDecimal beforeChangeRate;

    /**
     * 父ID
     */
    private Long parentId;

    private String tid;
    private String tpid;

    private List<ITreeNodeB> children;

    /**
     * 变更类型
     */
    private String changeType;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 档案分类Id
     */
    private Long docCategoryId;

    /**
     * 档案Id
     */
    private Long docId;

    /**
     * 总计划id（总计划来源的数据的总计划id）
     */
    private Long planId;

    /**
     * 当前清单被下游引用的次数
     */
    private Integer useNum;






    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public BigDecimal getDetailNum() {
        return detailNum;
    }

    public void setDetailNum(BigDecimal detailNum) {
        this.detailNum = detailNum;
    }

    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }



    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }



    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }

    public BigDecimal getBeforeChangeNum() {
        return beforeChangeNum;
    }

    public void setBeforeChangeNum(BigDecimal beforeChangeNum) {
        this.beforeChangeNum = beforeChangeNum;
    }

    public BigDecimal getBeforeChangePrice() {
        return beforeChangePrice;
    }

    public void setBeforeChangePrice(BigDecimal beforeChangePrice) {
        this.beforeChangePrice = beforeChangePrice;
    }

    public BigDecimal getBeforeChangeRate() {
        return beforeChangeRate;
    }

    public void setBeforeChangeRate(BigDecimal beforeChangeRate) {
        this.beforeChangeRate = beforeChangeRate;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }

    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Integer getUseNum() {
        return useNum;
    }

    public void setUseNum(Integer useNum) {
        this.useNum = useNum;
    }
}
