/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contractFileUpdate/"})
public class ContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IChangeService changeService;

    @PostMapping(value={"updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        contract.setContractFileSyncFlag(true);
        this.contractService.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getBillDataJson"})
    public CommonResponse<com.ejianc.business.proother.contract.vo.ContractVO> getBillDataJson(@RequestParam Long id) {
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(id));
        com.ejianc.business.proother.contract.vo.ContractVO vo = (com.ejianc.business.proother.contract.vo.ContractVO)BeanMapper.map((Object)((Object)contract), com.ejianc.business.proother.contract.vo.ContractVO.class);
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if (CollectionUtils.isNotEmpty((Collection)vo.getDetailList())) {
            vo.getDetailList().forEach(item -> {
                item.setDetailPriceStr(null != item.getDetailPrice() ? priceFmt.format(item.getDetailPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailTaxPriceStr(null != item.getDetailTaxPrice() ? priceFmt.format(item.getDetailTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailMnyStr(null != item.getDetailMny() ? mnyFmt.format(item.getDetailMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxMnyStr(null != item.getDetailTaxMny() ? mnyFmt.format(item.getDetailTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxStr(null != item.getDetailTax() ? mnyFmt.format(item.getDetailTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxRateStr(null != item.getDetailTaxRate() ? mnyFmt.format(item.getDetailTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailNumStr(null != item.getDetailNum() ? priceFmt.format(item.getDetailNum()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getOtherCostList())) {
            vo.getOtherCostList().forEach(item -> {
                item.setCostPriceStr(null != item.getCostPrice() ? priceFmt.format(item.getCostPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setCostTaxPriceStr(null != item.getCostTaxPrice() ? priceFmt.format(item.getCostTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setCostMnyStr(null != item.getCostMny() ? mnyFmt.format(item.getCostMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCostTaxMnyStr(null != item.getCostTaxMny() ? mnyFmt.format(item.getCostTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCostTaxStr(null != item.getCostTax() ? mnyFmt.format(item.getCostTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCostNumStr(null != item.getCostNum() ? priceFmt.format(item.getCostNum()) : priceFmt.format(BigDecimal.ZERO));
                item.setCostTaxRateStr(null != item.getCostTaxRate() ? mnyFmt.format(item.getCostTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"getSignedFileInfo"})
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        JSONObject resp = new JSONObject();
        ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
        ContractVO cv = new ContractVO();
        if ("contract".equals(billType)) {
            ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(billId));
            Assert.notNull((Object)((Object)entity), (String)"\u67e5\u8be2\u4e0d\u5230\u5408\u540c\u8be6\u60c5");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setBillType(ProotherBillTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getBillTypeCode());
            cv.setSourceType("proOtherContract");
            cvs.add(cv);
        } else {
            ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(billId));
            Assert.notNull((Object)((Object)changeEntity), (String)"\u67e5\u8be2\u4e0d\u5230\u53d8\u66f4\u5408\u540c\u8be6\u60c5");
            cv.setContractId(changeEntity.getId());
            cv.setContractName(changeEntity.getContractName());
            cv.setBillType(ProotherBillTypeEnum.\u5176\u4ed6\u5408\u540c\u53d8\u66f4.getBillTypeCode());
            cv.setSourceType("proOtherContractChange");
            cvs.add(cv);
        }
        CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
        if (!signResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\uff0cbillType-{}\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{billId, billType, signResp.getMsg()});
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        List fileList = (List)signResp.getData();
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return CommonResponse.error((String)"\u4e3a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
        if ("contract".equals(billType)) {
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(billId));
            contract.setSignedFileId(signedFileInfo.getFileId());
            this.contractService.saveOrUpdate((Object)contract, false);
        } else {
            ChangeEntity contractChange = (ChangeEntity)((Object)this.changeService.selectById(billId));
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            this.changeService.saveOrUpdate((Object)contractChange, false);
        }
        resp.put("fileId", (Object)signedFileInfo.getFileId());
        resp.put("filePath", (Object)signedFileInfo.getFilePath());
        resp.put("fileTruePath", (Object)signedFileInfo.getTruePath());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

