package com.ejianc.business.pro.ownrmat.api;

import com.ejianc.business.pro.ownrmat.hystrix.RmatAllotHystrix;
import com.ejianc.business.pro.ownrmat.vo.AllotInVO;
import com.ejianc.business.pro.ownrmat.vo.AllotOutVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(
        name = "ejc-prormat-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-prormat-web",
        fallback = RmatAllotHystrix.class
)
public interface IRmatAllotApi {

    @PostMapping("/api/allotOut/rmatCreateAllotIn")
    CommonResponse<String> rmatCreateAllotIn(@RequestBody AllotOutVO allotOutVO);

    @PostMapping("/api/allotOut/rmatCreateAllotIn")
    CommonResponse<String> rmatSureToReturn(@RequestBody AllotInVO allotInVO);

    @PostMapping("/api/allotOut/rmatCreateAllotIn")
    CommonResponse<String> rmatSureToReceive(@RequestBody AllotInVO allotInVO);

}
