package com.ejianc.business.pro.ownrmat.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 调拨入库
 * 
 * @author generator
 * 
 */
public class AllotInVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long allotOutId; // 调拨入库id
    private Long projectId; // 出库项目id
    private String projectName; // 入库项目名称
    private Long orgId; // 入库组织id
    private String orgName; // 入库组织名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long storeId; // 入库仓库id
    private String storeName; // 入库仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 调出的时间
    private BigDecimal outMny; // 调出金额
    private BigDecimal outTaxMny; // 调出金额
    private Integer allocatType; // 调拨方式 1 资产盘活 2 自制
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; //  经办人部门
    private Long outProjectId; // 调出项目id
    private String outProjectName; // 调出项目名称
    private Long outOrgId; // 调出组织id
    private String outOrgName; // 调出组织名称
    private String materialNames; // 出库物资名称集合
    private Long notifyReceiverId; // 通知收料状人id
    private String receiverName; // 调入组织收料状人
    private Long receiverPersonId; // 收料人id
    private String receiverPerson; // 收料人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiveDate; // 收料时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date passDate; // 通过时间
    private String returnReason; // 退回原因
    private Integer receiveState; // 收料状态 1、待收；2、已收；3、退回
    private String memo; // 备注
    private Long outStoreId; // 出库id
    private String outStoreName; // 出库名称
    private String billStateName;//单据状态名字
    private String receiveStateName;//收料状态名字
    private String allocatTypeName;//调拨方式 名字
    private List<AllotInDetailVO> allotInDetailList = new ArrayList<>(); // 调拨入库子表

    private String outAllocaScope; // 调出调拨范围(0-项目，1-组织)
    private String inAllocaScope; // 调入调拨范围(0-项目，1-组织)
    private String inUnitName; // 调入单位名称

    public String getInUnitName() {
        return inUnitName;
    }

    public void setInUnitName(String inUnitName) {
        this.inUnitName = inUnitName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getAllotOutId() {
        return allotOutId;
    }

    public void setAllotOutId(Long allotOutId) {
        this.allotOutId = allotOutId;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }


    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }

    public Integer getAllocatType() {
        return allocatType;
    }

    public void setAllocatType(Integer allocatType) {
        this.allocatType = allocatType;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getOutProjectId() {
        return outProjectId;
    }
    @ReferDeserialTransfer
    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }
    public String getOutProjectName() {
        return outProjectName;
    }

    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOutOrgId() {
        return outOrgId;
    }
    @ReferDeserialTransfer
    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }
    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getNotifyReceiverId() {
        return notifyReceiverId;
    }
    @ReferDeserialTransfer
    public void setNotifyReceiverId(Long notifyReceiverId) {
        this.notifyReceiverId = notifyReceiverId;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getReceiverPersonId() {
        return receiverPersonId;
    }
    @ReferDeserialTransfer
    public void setReceiverPersonId(Long receiverPersonId) {
        this.receiverPersonId = receiverPersonId;
    }

    public String getReceiverPerson() {
        return receiverPerson;
    }

    public void setReceiverPerson(String receiverPerson) {
        this.receiverPerson = receiverPerson;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public Date getPassDate() {
        return passDate;
    }

    public void setPassDate(Date passDate) {
        this.passDate = passDate;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public Integer getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getOutStoreId() {
        return outStoreId;
    }

    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }

    public String getOutStoreName() {
        return outStoreName;
    }

    public void setOutStoreName(String outStoreName) {
        this.outStoreName = outStoreName;
    }
    
     public List<AllotInDetailVO> getAllotInDetailList() {
        return allotInDetailList;
     }

     public void setAllotInDetailList(List<AllotInDetailVO> allotInDetailList) {
        this.allotInDetailList = allotInDetailList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getReceiveStateName() {
        return receiveStateName;
    }

    public void setReceiveStateName(String receiveStateName) {
        this.receiveStateName = receiveStateName;
    }

    public String getAllocatTypeName() {
        return allocatTypeName;
    }

    public void setAllocatTypeName(String allocatTypeName) {
        this.allocatTypeName = allocatTypeName;
    }

    public String getOutAllocaScope() {
        return outAllocaScope;
    }

    public void setOutAllocaScope(String outAllocaScope) {
        this.outAllocaScope = outAllocaScope;
    }

    public String getInAllocaScope() {
        return inAllocaScope;
    }

    public void setInAllocaScope(String inAllocaScope) {
        this.inAllocaScope = inAllocaScope;
    }

    public StoreManageVO getStoreManageVO(AllotInVO vo ){
        StoreManageVO storeManageVO = new StoreManageVO();
        if (vo!=null){
            storeManageVO.setStoreId(vo.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材调拨入库);
            storeManageVO.setSourceId(vo.getId());
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            vo.getAllotInDetailList().forEach(t->{
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材调拨入库, 0);
                flowVO.setStoreId(vo.getStoreId());
                flowVO.setStoreName(vo.getStoreName());
                flowVO.setProjectId(vo.getProjectId());
                flowVO.setProjectName(vo.getProjectName());
                flowVO.setOrgId(vo.getOrgId());
                flowVO.setOrgName(vo.getOrgName());
                flowVO.setParentOrgId(vo.getParentOrgId());
                flowVO.setParentOrgName(vo.getParentOrgName());
                flowVO.setParentOrgCode(vo.getParentOrgCode());
                flowVO.setEmployeeId(vo.getEmployeeId());
                flowVO.setEmployeeName(vo.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getMaterialSpec());
                flowVO.setMaterialUnitId(t.getMaterialUnitId());
                flowVO.setMaterialUnitName(t.getMaterialUnit());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setNum(t.getAllocatNum());
                flowVO.setTaxPrice(t.getAllocatTaxPrice());
                flowVO.setTaxMny(t.getAllocatTaxMny());
                flowVO.setMny(t.getAllocatMny());
                flowVO.setTax(t.getAllocatTax());
                flowVO.setPrice(t.getAllocatPrice());
                flowVO.setTaxRate(t.getAllocatTaxRate());
                flowVO.setSourceId(vo.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(vo.getBillCode());
                flowVO.setSourceBillDate(vo.getOutDate());
                flowVO.setSourceBillRemark(vo.getMemo());
                flowVO.setRowState("add");
                flowVO.setPurchasePrice(t.getOriginalValuePrice());
                flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
        }
        return storeManageVO;
    }
}
