package com.ejianc.business.pro.rmat.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2022/3/3 16:16
 */
public enum SettleEnum {

    过程结算("过程结算", "0"),
    最终结算("最终结算", "1"),

    支出("支出", "0"),
    收入("收入", "1");

    
    
    SettleEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    private String name;
    private String code;
    private static Map<String, SettleEnum> enumMap = new HashMap<>();


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    static {
        enumMap = EnumSet.allOf(SettleEnum.class).stream().collect(Collectors.toMap(SettleEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static SettleEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }
}
