package com.ejianc.business.pro.rmat.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ChangeCompareVO {

    private static final long serialVersionUID = 1L;
    
    private String contractName; // 合同名称
    private String firstPartyProjectManagerName; // 甲方项目负责人名称
    private String firstPartyEmployeeName; // 甲方经办人名称
    private String firstPartyPhone; // 甲方电话
    private String supplierName; // 乙方名称
    private String supplierEmployeeName; // 乙方经办人名称
    private String supplierPhone; // 乙方电话
    private String supplierAddress; // 乙方地址
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String signAddress; // 签订地点
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private Integer monthSettlementDay; // 月结算日
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentCalculationDate; // 计租日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endRentCalculationDate; // 止租日期
    private BigDecimal taxRate; // 合同税率
    private String supplyAddress; // 供货地点
    private BigDecimal contractMny; // 合同金额(不含税)
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal tax; // 合同税额
    private String invoiceTypeName; // 发票类型名称
    private BigDecimal detailTaxMny; // 清单金额
    private BigDecimal detailMny; // 清单金额(无税)
    private BigDecimal detailTax; // 清单税额
    private BigDecimal otherTaxMny; // 其他金额
    private BigDecimal otherMny; // 其他金额(无税)
    private BigDecimal otherTax; // 其他税额

    private List<ChangeDailyRentVO> dailyRentList = new ArrayList<>(); // 周转材租赁合同-日租明细变更表
    private List<ChangeMonthRentVO> monthRentList = new ArrayList<>(); // 周转材租赁合同-月租明细变更表
    private List<ChangeNumRentVO> numRentList = new ArrayList<>(); // 周转材租赁合同-工程量租明细表更表
    private List<ChangeRepairVO> repairList = new ArrayList<>(); // 周转材租赁合同-维修标准变更表
    private List<ChangeScrapVO> scrapList = new ArrayList<>(); // 周转材租赁合同-报废标准变更表
    private List<ChangeOtherVO> otherList = new ArrayList<>(); // 周转材租赁合同-其他费用变更表
    private List<ChangePaymentVO> paymentList = new ArrayList<>(); // 周转材租赁合同-付款阶段变更表
    private List<ChangeClauseVO> clauseList = new ArrayList<>(); // 周转材租赁合同-合同条款变更表

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    public String getFirstPartyEmployeeName() {
        return firstPartyEmployeeName;
    }

    public void setFirstPartyEmployeeName(String firstPartyEmployeeName) {
        this.firstPartyEmployeeName = firstPartyEmployeeName;
    }

    public String getFirstPartyPhone() {
        return firstPartyPhone;
    }

    public void setFirstPartyPhone(String firstPartyPhone) {
        this.firstPartyPhone = firstPartyPhone;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignAddress() {
        return signAddress;
    }

    public void setSignAddress(String signAddress) {
        this.signAddress = signAddress;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public Integer getMonthSettlementDay() {
        return monthSettlementDay;
    }

    public void setMonthSettlementDay(Integer monthSettlementDay) {
        this.monthSettlementDay = monthSettlementDay;
    }

    public Date getRentCalculationDate() {
        return rentCalculationDate;
    }

    public void setRentCalculationDate(Date rentCalculationDate) {
        this.rentCalculationDate = rentCalculationDate;
    }

    public Date getEndRentCalculationDate() {
        return endRentCalculationDate;
    }

    public void setEndRentCalculationDate(Date endRentCalculationDate) {
        this.endRentCalculationDate = endRentCalculationDate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getSupplyAddress() {
        return supplyAddress;
    }

    public void setSupplyAddress(String supplyAddress) {
        this.supplyAddress = supplyAddress;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public List<ChangeDailyRentVO> getDailyRentList() {
        return dailyRentList;
    }

    public void setDailyRentList(List<ChangeDailyRentVO> dailyRentList) {
        this.dailyRentList = dailyRentList;
    }

    public List<ChangeMonthRentVO> getMonthRentList() {
        return monthRentList;
    }

    public void setMonthRentList(List<ChangeMonthRentVO> monthRentList) {
        this.monthRentList = monthRentList;
    }

    public List<ChangeNumRentVO> getNumRentList() {
        return numRentList;
    }

    public void setNumRentList(List<ChangeNumRentVO> numRentList) {
        this.numRentList = numRentList;
    }

    public List<ChangeRepairVO> getRepairList() {
        return repairList;
    }

    public void setRepairList(List<ChangeRepairVO> repairList) {
        this.repairList = repairList;
    }

    public List<ChangeScrapVO> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<ChangeScrapVO> scrapList) {
        this.scrapList = scrapList;
    }

    public List<ChangeOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<ChangeOtherVO> otherList) {
        this.otherList = otherList;
    }

    public List<ChangePaymentVO> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<ChangePaymentVO> paymentList) {
        this.paymentList = paymentList;
    }

    public List<ChangeClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ChangeClauseVO> clauseList) {
        this.clauseList = clauseList;
    }
}
