package com.ejianc.business.pro.rmat.vo.record;

import com.ejianc.business.pro.rmat.vo.SettleVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SettleRecordVO {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    
    /**
     * 主合同主键
     */
    private Long mainContractId;
    
    /**
     * 合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同金额(无税)
     */
    private BigDecimal contractMny;

    /**
     * 累计结算金额
     */
    private BigDecimal totalSettleTaxMny;
    
    /**
     * 累计结算金额(无税)
     */
    private BigDecimal totalSettleMny;

    /**
     * 结算比例
     */
    private BigDecimal settleRate;
    
    /**
     * 合同履约状态：0-未签订，1-履约中，2-已终止，3-已作废，4-已冻结
     */
    private String performanceStatus;
    
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;
    private String rentType; // 租赁方式：0-外租，1-内租

    /**
     * 签章状态：0-未签章，1-待乙方签章，2-待甲方签章，3-已签章
     */
    private Integer signatureStatus;
    
    private List<SettleVO> detailList = new ArrayList<>();

    private boolean canAddNewSettleFlag; //是否可以创建新的结算单


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getSettleRate() {
        return settleRate;
    }

    public void setSettleRate(BigDecimal settleRate) {
        this.settleRate = settleRate;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public List<SettleVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SettleVO> detailList) {
        this.detailList = detailList;
    }

    public boolean isCanAddNewSettleFlag() {
        return canAddNewSettleFlag;
    }

    public void setCanAddNewSettleFlag(boolean canAddNewSettleFlag) {
        this.canAddNewSettleFlag = canAddNewSettleFlag;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }
}
