package com.ejianc.business.pro.rmat.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型编码常量
 */
public enum BillTypeEnum {

    租赁订单("租赁订单", "BT220209000000007"),
    验收单("验收单", "BT220210000000022"),
    启用单("启用单", "BT220209000000008"),
    停用单("停用单", "BT220209000000009"),
    退赔单("退赔单", "BT220210000000002"),
    遗失单("遗失单", "BT220210000000003"),
    周转材租赁合同("周转材租赁合同", "BT220210000000004"),
    周转材租赁合同变更("周转材租赁合同变更", "BT220210000000005"),
    周转材租赁合同记录("周转材租赁合同记录", "BT220210000000006"),
    租金计算单("租金计算单", "BT220312000000001"),
    周转材租赁合同解除("周转材租赁合同解除", "BT220305000000001"),
    周转材租赁合同结算单("周转材租赁合同结算单", "BT220310000000002"),
    ;

    private final String name;
    private final String code;
    private static Map<String, BillTypeEnum> enumMap = new HashMap();

    private BillTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static BillTypeEnum getEnumByName(String billTypeName) {
        return (BillTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(BillTypeEnum.class).stream().collect(Collectors.toMap(BillTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
