package com.ejianc.business.pro.ownrmat.api;

import com.ejianc.business.pro.ownrmat.hystrix.AmortizationHystrix;
import com.ejianc.business.pro.ownrmat.vo.AmortizationVO;
import com.ejianc.business.pro.ownrmat.vo.ResidualVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FeignClient(
        name = "ejc-prormat-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-prormat-web",
        fallback = AmortizationHystrix.class
)
public interface IAmortizationApi {

    /**
     * 周转材摊销比例设置查询
     *
     * @return 修改结果
     */
    @RequestMapping(
            value = {"/api/amortization/getResidualRate"},
            method = {RequestMethod.POST}
    )
    @ResponseBody
    public CommonResponse<Map<Long,AmortizationVO>> getResidualRate(@RequestBody ResidualVO vo);
}
