package com.ejianc.business.pro.pricelib.vo;

import com.ejianc.business.promaterial.pricelib.vo.PriceCheckVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceContractVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceSettlementVO;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 价格库-合同明细
 * 
 * @author generator
 * 
 */
public class PriceLibVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private String memo; // 备注
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private String area; // 项目地区
    private String areaName; // 项目地区
    private Long supplierId; // 乙方Id
    private String supplierName; // 乙方名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 合同签订日期
    private Long sourceId; // 来源主表id
    private String contractName; //合同名称
    private Long sourceDetailId; // 来源子表id
    private String performanceStatus; // 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
    private Integer contractType; // 合同类型（0-物资采购合同，1-混凝土合同）
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)（穿透使用）
    private String settlementPayment; // 结算付款
    private String priceFloatType; // 单价浮动方式
    private Long materialId; // 物料Id
    private String materialCode; // 物资编码
    private String materialName; // 物资名称
    private Long materialTypeId; // 物资分类Id
    private String materialTypeName; // 物资分类名称
    private String materialInnerCode; // 分类内码
    private String spec; // 规则/型号
    private Long unitId; // 计量单位主键
    private String unitName; // 计量单位
    private String brand; // 品牌
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private String rentCalculationName; // 计租方式：0-日租，1-月租，2-工程量租
    private BigDecimal contractNum; // 数量
    private BigDecimal contractPrice; // 单价(无税)
    private BigDecimal contractMny; // 金额(无税)
    private BigDecimal contractTaxRate; // 税率
    private BigDecimal contractTaxMny; // 金额(含税)
    private BigDecimal contractTaxPrice; // 单价(含税)

    private String marketPriceArea; // 市场价（无税）
    private String guidePriceArea; // 公司指导价（无税）
    private String contractPriceArea; // 合同价格区间（无税）
    private BigDecimal contractAvgPrice; // 合同均价(无税)
    private BigDecimal contractMaxPrice; // 合同最高价(无税)
    private BigDecimal contractMinPrice; // 合同最低价(无税)

    private String marketTaxPriceArea; // 市场价（含税）
    private String guideTaxPriceArea; // 公司指导价（含税）
    private String contractTaxPriceArea; // 合同价格区间（含税）
    private BigDecimal contractTaxAvgPrice; // 合同均价（含税）
    private BigDecimal contractTaxMaxPrice; // 合同最高价（含税）
    private BigDecimal contractTaxMinPrice; // 合同最低价（含税）

    List<PriceContractVO> priceContractList = new ArrayList<>();

    public String getRentCalculationName() {
        return rentCalculationName;
    }

    public void setRentCalculationName(String rentCalculationName) {
        this.rentCalculationName = rentCalculationName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public String getSettlementPayment() {
        return settlementPayment;
    }

    public void setSettlementPayment(String settlementPayment) {
        this.settlementPayment = settlementPayment;
    }

    public String getPriceFloatType() {
        return priceFloatType;
    }

    public void setPriceFloatType(String priceFloatType) {
        this.priceFloatType = priceFloatType;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialInnerCode() {
        return materialInnerCode;
    }

    public void setMaterialInnerCode(String materialInnerCode) {
        this.materialInnerCode = materialInnerCode;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }

    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractTaxPrice() {
        return contractTaxPrice;
    }

    public void setContractTaxPrice(BigDecimal contractTaxPrice) {
        this.contractTaxPrice = contractTaxPrice;
    }

    public String getMarketPriceArea() {
        return marketPriceArea;
    }

    public void setMarketPriceArea(String marketPriceArea) {
        this.marketPriceArea = marketPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getContractPriceArea() {
        return contractPriceArea;
    }

    public void setContractPriceArea(String contractPriceArea) {
        this.contractPriceArea = contractPriceArea;
    }

    public BigDecimal getContractAvgPrice() {
        return contractAvgPrice;
    }

    public void setContractAvgPrice(BigDecimal contractAvgPrice) {
        this.contractAvgPrice = contractAvgPrice;
    }

    public BigDecimal getContractMaxPrice() {
        return contractMaxPrice;
    }

    public void setContractMaxPrice(BigDecimal contractMaxPrice) {
        this.contractMaxPrice = contractMaxPrice;
    }

    public BigDecimal getContractMinPrice() {
        return contractMinPrice;
    }

    public void setContractMinPrice(BigDecimal contractMinPrice) {
        this.contractMinPrice = contractMinPrice;
    }

    public String getMarketTaxPriceArea() {
        return marketTaxPriceArea;
    }

    public void setMarketTaxPriceArea(String marketTaxPriceArea) {
        this.marketTaxPriceArea = marketTaxPriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public String getContractTaxPriceArea() {
        return contractTaxPriceArea;
    }

    public void setContractTaxPriceArea(String contractTaxPriceArea) {
        this.contractTaxPriceArea = contractTaxPriceArea;
    }

    public BigDecimal getContractTaxAvgPrice() {
        return contractTaxAvgPrice;
    }

    public void setContractTaxAvgPrice(BigDecimal contractTaxAvgPrice) {
        this.contractTaxAvgPrice = contractTaxAvgPrice;
    }

    public BigDecimal getContractTaxMaxPrice() {
        return contractTaxMaxPrice;
    }

    public void setContractTaxMaxPrice(BigDecimal contractTaxMaxPrice) {
        this.contractTaxMaxPrice = contractTaxMaxPrice;
    }

    public BigDecimal getContractTaxMinPrice() {
        return contractTaxMinPrice;
    }

    public void setContractTaxMinPrice(BigDecimal contractTaxMinPrice) {
        this.contractTaxMinPrice = contractTaxMinPrice;
    }

    public List<PriceContractVO> getPriceContractList() {
        return priceContractList;
    }

    public void setPriceContractList(List<PriceContractVO> priceContractList) {
        this.priceContractList = priceContractList;
    }
}
