package com.ejianc.business.pro.rmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 周转材租赁合同-记录表
 *
 * @author generator
 */
public class RecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long contractId; // 合同id
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码ID
    private String parentOrgName; // 父级组织名称ID
    private Integer addType; // 合同新增方式：0-参照定标结果新增，1-直接新增
    private String rentType; // 租赁方式：0-外租，1-内租
    private Long targetResultId; // 定标结果Id
    private String targetResultName; // 定标结果名称
    private String contractName; // 合同名称
    private String projectAddress; // 项目地址
    private Long contractCategoryId; // 合同类别Id
    private String contractCategoryName; // 合同类别名称
    private Long firstPartyId; // 甲方Id
    private String firstPartyName; // 甲方名称
    private Long firstPartyProjectManagerId; // 甲方项目负责人Id
    private String firstPartyProjectManagerName; // 甲方项目负责人名称
    private Long firstPartyEmployeeId; // 甲方经办人id
    private String firstPartyEmployeeName; // 甲方经办人名称
    private String firstPartyPhone; // 甲方电话
    private Long supplierId; // 乙方Id
    private String supplierName; // 乙方名称
    private Long supplierEmployeeId; // 乙方经办人id
    private String supplierEmployeeName; // 乙方经办人名称
    private String supplierPhone; // 乙方电话
    private String supplierAddress; // 乙方地址
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private Integer monthSettlementDay; // 月结算日
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentCalculationDate; // 计租日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endRentCalculationDate; // 止租日期
    private BigDecimal contractMny; // 合同金额(不含税)
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal taxRate; // 合同税率
    private BigDecimal tax; // 合同税额
    private String supplyAddress; // 供货地点
    private String performanceStatus; // 合同履约状态：1-未签订，2-履约中，3-已终止，4-已作废，5-已冻结
    private String draftType; // 起草方式：0-在线起草，1-上传合同，2-线下签订
    private Integer signatureStatus; // 签章状态：0-未签章，2-待乙方签章，3-待甲方签章，4-已签章
    private String contractFilePath; // 合同附件路径
    private Long contractFileId; // 合同附件Id
    private Long contractTemplateId; // 合同模板Id
    private String contractTemplateName; // 合同模板名称
    private Long contractFileVersionId; // 合同附件版本Id
    private Long contractFileVersion; // 合同附件版本
    private String contractFileHighlightPath; // 合同高亮附件路径
    private Long contractFileHighlightId; // 合同高亮附件Id
    private BigDecimal baseMny; // 初始版本金额(不含税)
    private BigDecimal baseTaxMny; // 初始版本金额
    private BigDecimal beforeChangeMny; // 变更前金额(不含税)
    private BigDecimal beforeChangeTaxMny; // 变更前金额
    private BigDecimal changingMny; // 变更中金额(不含税)
    private BigDecimal changingTaxMny; // 变更中金额
    private Long changeId; // 变更主键
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private String changeStatus; // 变更状态：1-未变更，2-变更中，3-已变更
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private String changeContractSignatureStatus; // 变更合同签章状态
    private String changeDraftType; // 变更起草方式：1-上传附件，2-线下签订
    private Long changeFileId; // 变更附件Id
    private String changeContractName; // 变更合同名称
    private Long signedFileId; // 签章完成合同文件Id
    private Long mainContractId; // 主合同Id
    private String mainContractCode; // 主合同编码
    private String mainContractName; // 主合同名称
    private String supplementDescribe; // 补充项描述
    private Integer supplementFlag; // 是否补充协议：0-否，1-是
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate; // 主合同创建日期(用于合同、补充协议排序)
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 备注

    private String billPushFlag; // 推送供方状态
    private String projectNewType; // 项目类型分类
    private String signAddress; // 签订地点

    private Integer filingStatus; // 是否归档：0-否，1-是，2-归档中(默认0)
    private Integer filingRef; // 是否归档引用：0-否，1-是(无默认，签章完成后修改)
    private Integer changeFilingStatus; // 是否归档：0-否，1-是，2-归档中(默认0)

    private BigDecimal targetTaxMny; // 定标金额
    private Integer purchaseType; // 招标类型：0-项目采购，1-公司采购

    private BigDecimal detailTaxMny; // 清单金额
    private BigDecimal detailMny; // 清单金额(无税)
    private BigDecimal detailTax; // 清单税额
    private BigDecimal otherTaxMny; // 其他金额
    private BigDecimal otherMny; // 其他金额(无税)
    private BigDecimal otherTax; // 其他税额

    private Long watermarkContractFileId; // 水印合同附件Id
    private String purchaseId; // 供货内容id
    private String purchaseName; // 供货内容名称


    private List<RecordDailyRentVO> dailyRentList = new ArrayList<>(); // 周转材租赁合同-日租明细记录表
    private List<RecordMonthRentVO> monthRentList = new ArrayList<>(); // 周转材租赁合同-月租明细记录表
    private List<RecordNumRentVO> numRentList = new ArrayList<>(); // 周转材租赁合同-工程量租明细记录表
    private List<RecordRepairVO> repairList = new ArrayList<>(); // 周转材租赁合同-维修标准记录表
    private List<RecordScrapVO> scrapList = new ArrayList<>(); // 周转材租赁合同-报废标准记录表
    private List<RecordOtherVO> otherList = new ArrayList<>(); // 周转材租赁合同-其他费用记录表
    private List<RecordPaymentVO> paymentList = new ArrayList<>(); // 周转材租赁合同-付款阶段记录表
    private List<RecordClauseVO> clauseList = new ArrayList<>(); // 周转材租赁合同-合同条款记录表

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }

    public Long getTargetResultId() {
        return targetResultId;
    }

    @ReferDeserialTransfer
    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getFirstPartyProjectManagerId() {
        return firstPartyProjectManagerId;
    }

    public void setFirstPartyProjectManagerId(Long firstPartyProjectManagerId) {
        this.firstPartyProjectManagerId = firstPartyProjectManagerId;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFirstPartyEmployeeId() {
        return firstPartyEmployeeId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyEmployeeId(Long firstPartyEmployeeId) {
        this.firstPartyEmployeeId = firstPartyEmployeeId;
    }

    public String getFirstPartyEmployeeName() {
        return firstPartyEmployeeName;
    }

    public void setFirstPartyEmployeeName(String firstPartyEmployeeName) {
        this.firstPartyEmployeeName = firstPartyEmployeeName;
    }

    public String getFirstPartyPhone() {
        return firstPartyPhone;
    }

    public void setFirstPartyPhone(String firstPartyPhone) {
        this.firstPartyPhone = firstPartyPhone;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getSupplierEmployeeId() {
        return supplierEmployeeId;
    }

    @ReferDeserialTransfer
    public void setSupplierEmployeeId(Long supplierEmployeeId) {
        this.supplierEmployeeId = supplierEmployeeId;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public Integer getMonthSettlementDay() {
        return monthSettlementDay;
    }

    public void setMonthSettlementDay(Integer monthSettlementDay) {
        this.monthSettlementDay = monthSettlementDay;
    }

    public Date getRentCalculationDate() {
        return rentCalculationDate;
    }

    public void setRentCalculationDate(Date rentCalculationDate) {
        this.rentCalculationDate = rentCalculationDate;
    }

    public Date getEndRentCalculationDate() {
        return endRentCalculationDate;
    }

    public void setEndRentCalculationDate(Date endRentCalculationDate) {
        this.endRentCalculationDate = endRentCalculationDate;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getSupplyAddress() {
        return supplyAddress;
    }

    public void setSupplyAddress(String supplyAddress) {
        this.supplyAddress = supplyAddress;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    
    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }

    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(String changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }

    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }

    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }

    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getProjectNewType() {
        return projectNewType;
    }

    public void setProjectNewType(String projectNewType) {
        this.projectNewType = projectNewType;
    }

    public String getSignAddress() {
        return signAddress;
    }

    public void setSignAddress(String signAddress) {
        this.signAddress = signAddress;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public Integer getChangeFilingStatus() {
        return changeFilingStatus;
    }

    public void setChangeFilingStatus(Integer changeFilingStatus) {
        this.changeFilingStatus = changeFilingStatus;
    }

    public List<RecordDailyRentVO> getDailyRentList() {
        return dailyRentList;
    }

    public void setDailyRentList(List<RecordDailyRentVO> dailyRentList) {
        this.dailyRentList = dailyRentList;
    }

    public List<RecordMonthRentVO> getMonthRentList() {
        return monthRentList;
    }

    public void setMonthRentList(List<RecordMonthRentVO> monthRentList) {
        this.monthRentList = monthRentList;
    }

    public List<RecordNumRentVO> getNumRentList() {
        return numRentList;
    }

    public void setNumRentList(List<RecordNumRentVO> numRentList) {
        this.numRentList = numRentList;
    }

    public List<RecordRepairVO> getRepairList() {
        return repairList;
    }

    public void setRepairList(List<RecordRepairVO> repairList) {
        this.repairList = repairList;
    }

    public List<RecordScrapVO> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<RecordScrapVO> scrapList) {
        this.scrapList = scrapList;
    }

    public List<RecordOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<RecordOtherVO> otherList) {
        this.otherList = otherList;
    }

    public List<RecordPaymentVO> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<RecordPaymentVO> paymentList) {
        this.paymentList = paymentList;
    }

    public List<RecordClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<RecordClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public BigDecimal getTargetTaxMny() {
        return targetTaxMny;
    }

    public void setTargetTaxMny(BigDecimal targetTaxMny) {
        this.targetTaxMny = targetTaxMny;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public Long getWatermarkContractFileId() {
        return watermarkContractFileId;
    }

    public void setWatermarkContractFileId(Long watermarkContractFileId) {
        this.watermarkContractFileId = watermarkContractFileId;
    }
}
