package com.ejianc.business.pro.rmat.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.rmat.hystrix.PrormatContractHystrix;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(
        name = "ejc-prormat-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-prormat-web",
        fallback = PrormatContractHystrix.class
)
public interface IPrormatContractApi {

    /**
     * 根据定标参照id查询对应的合同
     *
     * @param targetResultIdList 定标结果参照id
     * @return 修改结果
     */
    @GetMapping(value = "/api/prormat/queryContractByTargetResultId")
    CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam("targetResultIdList") List<String> targetResultIdList);

    /**
     * 接收辅料中心内租合同
     * @param json,type
     * @return
     */
    @PostMapping(value = "/api/prormat/contractSync")
    CommonResponse<String> contractSync(@RequestBody JSONObject json,@RequestParam("type") String type);

    /**
     * 辅料中心内租合同删除
     * @param id,type
     * @return
     */
    @PostMapping(value = "/api/prormat/delContract")
    CommonResponse<String> delContract(@RequestParam("id") Long id,@RequestParam("type") String type);
}
