package com.ejianc.business.pro.rmat.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ContractSyncTypeEnum {
    //合同
    周转材租赁合同("周转材租赁合同", "BT220210000000004"),
    //变更
    周转材租赁合同变更("周转材租赁合同变更", "BT220210000000005"),
    //合同解除
    周转材租赁合同解除("周转材租赁合同解除", "BT220305000000001"),
    //合同冻结
    周转材租赁合同冻结("周转材租赁合同冻结", "BT220305000000002"),
    //变更签章更新生效状态
    变更更新合同状态("变更更新合同状态", "BT220210000000005"),
    ;

    private final String name;
    private final String code;
    private static Map<String, ContractSyncTypeEnum> enumMap = new HashMap();

    private ContractSyncTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static ContractSyncTypeEnum getEnumByName(String billTypeName) {
        return (ContractSyncTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(ContractSyncTypeEnum.class).stream().collect(Collectors.toMap(ContractSyncTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
