package com.ejianc.business.pro.rmat.enums;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ReceiptsEnum {
    //周转材租赁订单
    租赁订单("租赁订单", "BT220209000000007","supplierSignImg",""),
    //周转材验收单
    验收单("验收单", "BT220210000000022","supplierSignImg","租出验收单"),
    //周转材启用单
    启用单("启用单", "BT220209000000008","supplierSignImg","租出启用单"),
    //周转材停用单
    停用单("停用单", "BT220209000000009","supplierSignImg","租出停用单"),
    //周转材退赔单
    退赔单("退赔单", "BT220210000000002","supplierSignImg","租出退赔单"),
    //周转材遗失单
    遗失单("遗失单", "BT220210000000003","supplierSignImg","租出遗失单"),
    //周转材结算单
    周转材租赁合同结算单("周转材租赁合同结算单", "BT220310000000002","supplierSignImg","辅料中心租出合同结算单"),
    //周转材租金计算单
    租金计算单("租金计算单", "BT220312000000001","supplierSignImg1","租金计算单");

    private final String name;
    private final String code;
    private final String fileType;
    private final String sourceName;
    private static Map<String, ReceiptsEnum> enumMap;
    private static Map<String, ReceiptsEnum> enumMap1;

    private ReceiptsEnum(String name, String code, String fileType,String sourceName) {
        this.name = name;
        this.code = code;
        this.fileType = fileType;
        this.sourceName = sourceName;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getFileType() {
        return fileType;
    }

    public String getSourceName() {
        return sourceName;
    }

    public static ReceiptsEnum getEnumByName(String billTypeName) {
        return enumMap.get(billTypeName);
    }

    public static ReceiptsEnum getEnumBySourceName(String billTypeName) {
        return enumMap1.get(billTypeName);
    }

    static {
        enumMap = EnumSet.allOf(ReceiptsEnum.class).stream().collect(Collectors.toMap(ReceiptsEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
        enumMap1  = EnumSet.allOf(ReceiptsEnum.class).stream().collect(Collectors.toMap(ReceiptsEnum::getSourceName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
