package com.ejianc.business.pro.ownrmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 周转材处置明细表
 * 
 * @author generator
 * 
 */
public class HandleDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long handleId; // 处置ID
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialCategoryCode")
    private Long materialCategoryId; // 物资分类Id
    private String materialCategoryName; // 物资分类名称

    private Long materialId; // 物资Id
    private String materialName; // 物资名称
    private String materialCode; // 物资编号
    private String spec; // 规格型号
    private Long unit; // 计量单位
    private String unitName; // 计量单位
    private BigDecimal surplusNum; // 库存余量
    private BigDecimal handlePrice; // 处置单价
    private BigDecimal handleNum; // 处置数量
    private BigDecimal handleMny; // 处置金额
    private BigDecimal tax; // 处置税额
    private BigDecimal handleSubTaxMny; // 处置差额
    private BigDecimal handleSubMny; // 处置差额(无税)
    private String memo; // 备注
    private BigDecimal handleTaxPrice; // 处置单价(含税)
    private BigDecimal netWorthTaxMny; // 材料净值(含税)
    private BigDecimal residualValueTaxMny; // 材料残值(含税)
    private BigDecimal netWorthMny; // 材料净值(无税)
    private BigDecimal residualValueMny; // 材料残值(无税)
    private BigDecimal residualValueRate; // 残值率
    private BigDecimal originalValueTaxPrice; // 原值单价(含税)
    private BigDecimal originalValuePrice; // 原值单价(无税)
    private BigDecimal originalValueTaxMny; // 材料原值(含税)
    private BigDecimal originalValueMny; // 材料原值(无税)
    private BigDecimal onHandNum; // 在场数量
    private BigDecimal taxRate; // 税率
    private BigDecimal handleTaxMny; // 处置金额
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称
    private String materialCategoryCode; // 物资分类编码
    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }

    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getHandleId() {
        return handleId;
    }

    public void setHandleId(Long handleId) {
        this.handleId = handleId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnit() {
        return unit;
    }

    public void setUnit(Long unit) {
        this.unit = unit;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }
    public BigDecimal getHandlePrice() {
        return handlePrice;
    }

    public void setHandlePrice(BigDecimal handlePrice) {
        this.handlePrice = handlePrice;
    }
    public BigDecimal getHandleNum() {
        return handleNum;
    }

    public void setHandleNum(BigDecimal handleNum) {
        this.handleNum = handleNum;
    }
    public BigDecimal getHandleMny() {
        return handleMny;
    }

    public void setHandleMny(BigDecimal handleMny) {
        this.handleMny = handleMny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getHandleSubTaxMny() {
        return handleSubTaxMny;
    }

    public void setHandleSubTaxMny(BigDecimal handleSubTaxMny) {
        this.handleSubTaxMny = handleSubTaxMny;
    }
    public BigDecimal getHandleSubMny() {
        return handleSubMny;
    }

    public void setHandleSubMny(BigDecimal handleSubMny) {
        this.handleSubMny = handleSubMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getHandleTaxPrice() {
        return handleTaxPrice;
    }

    public void setHandleTaxPrice(BigDecimal handleTaxPrice) {
        this.handleTaxPrice = handleTaxPrice;
    }

    public BigDecimal getNetWorthTaxMny() {
        return netWorthTaxMny;
    }

    public void setNetWorthTaxMny(BigDecimal netWorthTaxMny) {
        this.netWorthTaxMny = netWorthTaxMny;
    }

    public BigDecimal getResidualValueTaxMny() {
        return residualValueTaxMny;
    }

    public void setResidualValueTaxMny(BigDecimal residualValueTaxMny) {
        this.residualValueTaxMny = residualValueTaxMny;
    }

    public BigDecimal getNetWorthMny() {
        return netWorthMny;
    }

    public void setNetWorthMny(BigDecimal netWorthMny) {
        this.netWorthMny = netWorthMny;
    }

    public BigDecimal getResidualValueMny() {
        return residualValueMny;
    }

    public void setResidualValueMny(BigDecimal residualValueMny) {
        this.residualValueMny = residualValueMny;
    }

    public BigDecimal getResidualValueRate() {
        return residualValueRate;
    }

    public void setResidualValueRate(BigDecimal residualValueRate) {
        this.residualValueRate = residualValueRate;
    }

    public BigDecimal getOriginalValueTaxPrice() {
        return originalValueTaxPrice;
    }

    public void setOriginalValueTaxPrice(BigDecimal originalValueTaxPrice) {
        this.originalValueTaxPrice = originalValueTaxPrice;
    }

    public BigDecimal getOriginalValuePrice() {
        return originalValuePrice;
    }

    public void setOriginalValuePrice(BigDecimal originalValuePrice) {
        this.originalValuePrice = originalValuePrice;
    }

    public BigDecimal getOriginalValueTaxMny() {
        return originalValueTaxMny;
    }

    public void setOriginalValueTaxMny(BigDecimal originalValueTaxMny) {
        this.originalValueTaxMny = originalValueTaxMny;
    }

    public BigDecimal getOriginalValueMny() {
        return originalValueMny;
    }

    public void setOriginalValueMny(BigDecimal originalValueMny) {
        this.originalValueMny = originalValueMny;
    }

    public BigDecimal getOnHandNum() {
        return onHandNum;
    }

    public void setOnHandNum(BigDecimal onHandNum) {
        this.onHandNum = onHandNum;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getHandleTaxMny() {
        return handleTaxMny;
    }

    public void setHandleTaxMny(BigDecimal handleTaxMny) {
        this.handleTaxMny = handleTaxMny;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
}
