package com.ejianc.business.pro.pricelib.api;

import com.ejianc.business.pro.pricelib.hystrix.RentPriceHistoryHystrix;
import com.ejianc.business.pro.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(
        name = "ejc-prormat-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-prormat-web",
        fallback = RentPriceHistoryHystrix.class
)
public interface IRentPriceHistoryApi {
    @ApiOperation("查询单个物资历史价格")
    @GetMapping(value = "/api/MaterialPriceHistoryApi/getMaterialPriceHistoryApiVO")
    CommonResponse<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVO(@RequestParam("materialId") Long materialId,@RequestParam("rentCalculationType") String rentCalculationType);

    @ApiOperation("查询多个个物资历史价格")
    @PostMapping(value = "/api/MaterialPriceHistoryApi/getMaterialPriceHistoryApiVOS")
    CommonResponse<List<MaterialPriceHistoryApiVO>> getMaterialPriceHistoryApiVOS(@RequestBody List<Long> materialIds,@RequestParam("rentCalculationType") String rentCalculationType);

    @ApiOperation("查询多个个物资历史价格")
    @PostMapping("getMaterialPriceHistoryApiVOMap")
    CommonResponse<Map<Long,MaterialPriceHistoryApiVO>> getMaterialPriceHistoryApiVOMap(@RequestBody List<Long> materialIds,@RequestParam("rentCalculationType") String rentCalculationType);
}
