package com.ejianc.business.pro.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 周转材批次计划-报废标准
 * 
 * @author generator
 * 
 */
public class BatchPlanScrapVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long batchId; // 批次计划主键id
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialTypeCode")
    private Long materialTypeId; // 物资材料分类Id
    private String materialTypeName; // 物资材料分类名称
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private String materialName; // 材料名称
    private String spec; // 规则/型号
    private Long unitId; // 计量单位id
    private String unitName; // 计量单位名称
    private String damageScrapName; // 损坏报废名称
    private Long damageScrapUnitId; // 损坏报废单位id
    private String damageScrapUnitName; // 损坏报废单位名称
    private BigDecimal damageScrapPrice; // 损坏报废单价(无税)
    private BigDecimal damageScrapTaxPrice; // 损坏报废单价
    private BigDecimal taxRate; // 税率
    private BigDecimal tax; // 税额
    private String memo; // 备注
    private Long sourceId; // 来源数据Id
    private String sourceType; // 来源类型：1-总计划，2-档案
    private String materialTypeCode; // 材料分类编码

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public Long getBatchId() {
        return batchId;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getDamageScrapName() {
        return damageScrapName;
    }

    public void setDamageScrapName(String damageScrapName) {
        this.damageScrapName = damageScrapName;
    }
    public Long getDamageScrapUnitId() {
        return damageScrapUnitId;
    }

    public void setDamageScrapUnitId(Long damageScrapUnitId) {
        this.damageScrapUnitId = damageScrapUnitId;
    }
    public String getDamageScrapUnitName() {
        return damageScrapUnitName;
    }

    public void setDamageScrapUnitName(String damageScrapUnitName) {
        this.damageScrapUnitName = damageScrapUnitName;
    }
    public BigDecimal getDamageScrapPrice() {
        return damageScrapPrice;
    }

    public void setDamageScrapPrice(BigDecimal damageScrapPrice) {
        this.damageScrapPrice = damageScrapPrice;
    }
    public BigDecimal getDamageScrapTaxPrice() {
        return damageScrapTaxPrice;
    }

    public void setDamageScrapTaxPrice(BigDecimal damageScrapTaxPrice) {
        this.damageScrapTaxPrice = damageScrapTaxPrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    
}
