package com.ejianc.business.pro.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pro.rmat.vo.BatchPlanDetailVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 周转材批次计划
 * 
 * @author generator
 * 
 */
public class BatchPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String billCode; // 单据编号
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private BigDecimal estimatedMny; // 暂估金额
    private BigDecimal estimatedMnyNoTax; // 暂估金额（无税）
    private Integer tenderStatus; // 招标状态
    private String categoryName; // 材料分类名称
    private String memo; // 备注
    private Integer billState; // 单据状态
    private String billStateName;
    private Integer rentType; // 租赁方式(0-日租,1-月租,2-工程量租)
    private String rentTypeName; // 租赁方式(0-日租,1-月租,2-工程量租)

    private Integer rentalType; // 出租运输方式(1-承租方,2-租赁方)
    private String rentalTypeName; // 租赁方式(1-承租方,2-租赁方)
    private Integer backType; // 归还运输方式(1-承租方,2-租赁方)
    private String backTypeName; // 租赁方式(1-承租方,2-租赁方)
    private Integer rentalStacking; // 出租堆码(1-承租方,2-租赁方)
    private String rentalStackingName; // 出租堆码(1-承租方,2-租赁方)
    private Integer backStacking; // 归还堆码(1-承租方,2-租赁方)
    private String backStackingName; // 归还堆码(1-承租方,2-租赁方)

    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    private String standard; // 质量标准
    private String paymentType; // 付款方式 1-500字

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    @SubEntity
    private List<BatchPlanDetailVO> detailList = new ArrayList<>(); // 周转材批次计划-清单
    @SubEntity
    private List<BatchPlanRepairVO> repairList = new ArrayList<>(); // 周转材批次计划-维修标准
    @SubEntity
    private List<BatchPlanScrapVO> scrapList = new ArrayList<>(); // 周转材批次计划-报废标准

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getEstimatedMny() {
        return estimatedMny;
    }

    public void setEstimatedMny(BigDecimal estimatedMny) {
        this.estimatedMny = estimatedMny;
    }

    public BigDecimal getEstimatedMnyNoTax() {
        return estimatedMnyNoTax;
    }

    public void setEstimatedMnyNoTax(BigDecimal estimatedMnyNoTax) {
        this.estimatedMnyNoTax = estimatedMnyNoTax;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<BatchPlanDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BatchPlanDetailVO> detailList) {
        this.detailList = detailList;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Integer getTenderStatus() {
        return tenderStatus;
    }

    public void setTenderStatus(Integer tenderStatus) {
        this.tenderStatus = tenderStatus;
    }

    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }

    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }

    public Integer getRentalType() {
        return rentalType;
    }

    public void setRentalType(Integer rentalType) {
        this.rentalType = rentalType;
    }

    public Integer getBackType() {
        return backType;
    }

    public void setBackType(Integer backType) {
        this.backType = backType;
    }

    public Integer getRentalStacking() {
        return rentalStacking;
    }

    public void setRentalStacking(Integer rentalStacking) {
        this.rentalStacking = rentalStacking;
    }

    public Integer getBackStacking() {
        return backStacking;
    }

    public void setBackStacking(Integer backStacking) {
        this.backStacking = backStacking;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public List<BatchPlanRepairVO> getRepairList() {
        return repairList;
    }

    public void setRepairList(List<BatchPlanRepairVO> repairList) {
        this.repairList = repairList;
    }

    public List<BatchPlanScrapVO> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<BatchPlanScrapVO> scrapList) {
        this.scrapList = scrapList;
    }

    public String getRentalTypeName() {
        return rentalTypeName;
    }

    public void setRentalTypeName(String rentalTypeName) {
        this.rentalTypeName = rentalTypeName;
    }

    public String getBackTypeName() {
        return backTypeName;
    }

    public void setBackTypeName(String backTypeName) {
        this.backTypeName = backTypeName;
    }

    public String getRentalStackingName() {
        return rentalStackingName;
    }

    public void setRentalStackingName(String rentalStackingName) {
        this.rentalStackingName = rentalStackingName;
    }

    public String getBackStackingName() {
        return backStackingName;
    }

    public void setBackStackingName(String backStackingName) {
        this.backStackingName = backStackingName;
    }

    public String getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }
}
