package com.ejianc.business.pro.rmat.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MaterialStateEnum {
    /**
     * 物料状态: 1-入场
     */
    入场(1, "入场"),
    /**
     * 物料状态: 2-启用
     */
    启用(2, "启用"),
    /**
     * 物料状态: 3-停用
     */
    停用(3, "停用"),
    /**
     * 物料状态: 4-退场
     */
    退场(4, "退场");


    private Integer code;
    private String description;
    private static Map<Integer, MaterialStateEnum> enumMap = new HashMap<>();

    MaterialStateEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(MaterialStateEnum.class).stream().collect(Collectors
                .toMap(MaterialStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static MaterialStateEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
