package com.ejianc.business.pro.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 租金计算单-日租
 * 
 * @author generator
 * 
 */
public class RentCalculateDailyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long rentId; // 主表主键
    private Long sourceId; // 来源数据Id
    private Long materialTypeId; // 物资材料分类Id
    private String materialTypeName; // 物资材料分类名称
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private String materialName; // 材料名称
    private String spec; // 规格/型号
    private Long unitId; // 计量单位id
    private String unitName; // 计量单位名称
    private BigDecimal num; // 数量
    private BigDecimal unitTaxPrice; // 日租单价
    private BigDecimal unitPrice; // 日租单价(无税)
    private BigDecimal stopUnitTaxPrice; // 停租单价
    private BigDecimal stopUnitPrice; // 停租单价(无税)
    private BigDecimal taxRate; // 税率
    private BigDecimal dailyRentTaxMny; // 日租租金
    private BigDecimal dailyRentMny; // 日租租金(无税)
    private BigDecimal dailyTax; // 税额
    private Date startDate; // 计费开始日期
    private Date endDate; // 计费结束日期
    private String useStatus; // 使用状态：0-启用，1-停用
    private String memo; // 备注
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称
    private Integer rentDayDate;// 租期/天

    public Integer getRentDayDate() {
        return rentDayDate;
    }

    public void setRentDayDate(Integer rentDayDate) {
        this.rentDayDate = rentDayDate;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }

    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getRentId() {
        return rentId;
    }

    public void setRentId(Long rentId) {
        this.rentId = rentId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getStopUnitTaxPrice() {
        return stopUnitTaxPrice;
    }

    public void setStopUnitTaxPrice(BigDecimal stopUnitTaxPrice) {
        this.stopUnitTaxPrice = stopUnitTaxPrice;
    }
    public BigDecimal getStopUnitPrice() {
        return stopUnitPrice;
    }

    public void setStopUnitPrice(BigDecimal stopUnitPrice) {
        this.stopUnitPrice = stopUnitPrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getDailyRentTaxMny() {
        return dailyRentTaxMny;
    }

    public void setDailyRentTaxMny(BigDecimal dailyRentTaxMny) {
        this.dailyRentTaxMny = dailyRentTaxMny;
    }
    public BigDecimal getDailyRentMny() {
        return dailyRentMny;
    }

    public void setDailyRentMny(BigDecimal dailyRentMny) {
        this.dailyRentMny = dailyRentMny;
    }
    public BigDecimal getDailyTax() {
        return dailyTax;
    }

    public void setDailyTax(BigDecimal dailyTax) {
        this.dailyTax = dailyTax;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
