package com.ejianc.business.pro.rmat.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.rmat.hystrix.ReceiptsHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(
        name = "ejc-prormat-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-prormat-web",
        fallback = ReceiptsHystrix.class
)
public interface IReceiptsApi {

    /**
     * 接收辅料中心推送的内租单据
     * @param json,type 单据标识
     */
    @PostMapping(value = "/api/prormat/receiptsSync")
    CommonResponse<String> receiptsSync(@RequestBody JSONObject json, @RequestParam("type") String type);

    /**
     * 辅料中心内租单据删除
     * @param id,type 单据标识
     * @return
     */
    @PostMapping(value = "/api/prormat/delReceipts")
    CommonResponse<String> delReceipts(@RequestParam("id") Long id, @RequestParam("type") String type);

    /**
     * 订单变更送货状态
     * @param jsonArray
     * @return
     */
    @PostMapping(value = "/api/prormat/orderChangeStatus")
    CommonResponse<String> orderChangeStatus(@RequestBody JSONArray jsonArray);
}
