package com.ejianc.business.pro.rmat.api;

import com.ejianc.business.pro.rmat.hystrix.RentCalculateHystrix;
import com.ejianc.business.pro.rmat.vo.SourceBliVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

@FeignClient(name= "ejc-prormat-web", url="${common.env.feign-client-url}", path="ejc-prormat-web", fallback = RentCalculateHystrix.class)
public interface IRentCalculateApi {
    /**
     * 根据合同ID(contractId)查询该合同下已生效租金计算金额之和
     * @param contractId
     * @return
     */
    @GetMapping("/api/rentCalculateApi/queryRentMny")
    public CommonResponse<BigDecimal> queryRentMny(@RequestParam(value = "contractId") Long contractId);

    /**
     * 周转材管理：
     * 1、累计单据数量：查该供应商在本下项目生效的  周转材验收单、结算单数量；
     * 2、协同单据数量：查该供应商在本下项目生效的  周转材验收单（订单）、结算单（已签字）的数量；
     * 3、比例：协同单据数量/累计单据数量；
     * @param supplierId
     * @param dateIn
     * @return
     */
    @GetMapping(value = "/api/rentCalculateApi/getSourceBliVO")
    CommonResponse<SourceBliVO> getSourceBliVO(@RequestParam(value = "supplierId") Long supplierId, @RequestParam(value = "dateIn", required = false) String dateIn);
}
