package com.ejianc.business.pro.rmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 结算单-维修金额
 *
 * @author generator
 */
public class SettleRepairVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long settleId; // 结算id
    private Long sourceId; // 来源数据Id
    private String restituteBillCode; // 退赔单据编码
    private BigDecimal repairTaxMny; // 本次维修金额
    private BigDecimal repairMny; // 本次维修金额(无税)
    private BigDecimal repairTax; // 维修税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date refundDate; // 退赔日期
    private String memo; // 备注

    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getRestituteBillCode() {
        return restituteBillCode;
    }

    public void setRestituteBillCode(String restituteBillCode) {
        this.restituteBillCode = restituteBillCode;
    }

    public BigDecimal getRepairTaxMny() {
        return repairTaxMny;
    }

    public void setRepairTaxMny(BigDecimal repairTaxMny) {
        this.repairTaxMny = repairTaxMny;
    }

    public BigDecimal getRepairMny() {
        return repairMny;
    }

    public void setRepairMny(BigDecimal repairMny) {
        this.repairMny = repairMny;
    }

    public BigDecimal getRepairTax() {
        return repairTax;
    }

    public void setRepairTax(BigDecimal repairTax) {
        this.repairTax = repairTax;
    }

    public Date getRefundDate() {
        return refundDate;
    }

    public void setRefundDate(Date refundDate) {
        this.refundDate = refundDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }

    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

}
