/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.rmat.bean.TotalPlanDetailEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanEntity;
import com.ejianc.business.pro.rmat.service.ITotalPlanDetailService;
import com.ejianc.business.pro.rmat.service.ITotalPlanService;
import com.ejianc.business.pro.rmat.utils.PageUtil;
import com.ejianc.business.pro.rmat.utils.SortUtil;
import com.ejianc.business.pro.rmat.utils.TreeNodeBUtil;
import com.ejianc.business.pro.rmat.vo.TotalPlanDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"totalPlanDetail"})
public class TotalPlanDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ITotalPlanDetailService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITotalPlanService totalPlanService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalPlanDetailVO> saveOrUpdate(@RequestBody TotalPlanDetailVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        TotalPlanDetailEntity entity = (TotalPlanDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TotalPlanDetailEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        TotalPlanDetailVO vo = (TotalPlanDetailVO)BeanMapper.map((Object)((Object)entity), TotalPlanDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TotalPlanDetailVO> queryDetail(Long id) {
        TotalPlanDetailEntity entity = (TotalPlanDetailEntity)((Object)this.service.selectById(id));
        TotalPlanDetailVO vo = (TotalPlanDetailVO)BeanMapper.map((Object)((Object)entity), TotalPlanDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TotalPlanDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TotalPlanDetailVO totalPlanDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TotalPlanDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TotalPlanDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TotalPlanDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTotalPlanDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TotalPlanDetailVO> refTotalPlanDetailData(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        Map conditionMap;
        List<Object> res = new ArrayList<TotalPlanDetailVO>();
        QueryParam queryParam = new QueryParam();
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("materialTypeName");
        queryParam.getFuzzyFields().add("materialName");
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambd.eq(TotalPlanEntity::getProjectId, (Object)projectId);
            lambd.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
            lambd.in(TotalPlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            List list = this.totalPlanService.list((Wrapper)lambd);
            if (null != list && list.size() > 0) {
                Long totalId = ((TotalPlanEntity)((Object)list.get(0))).getId();
                queryParam.getParams().put("totalId", new Parameter("eq", (Object)totalId));
                List totalPlanDetailEntities = this.service.queryList(queryParam, false);
                List detailVoListDb = BeanMapper.mapList((Iterable)totalPlanDetailEntities, TotalPlanDetailVO.class);
                ArrayList detailVoList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)detailVoListDb)) {
                    detailVoListDb.forEach(detailEntity -> {
                        if (null == detailEntity.getChangeType() || 2 != detailEntity.getChangeType()) {
                            detailVoList.add(detailEntity);
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(detailVoList)) {
                    new SortUtil().entryListToSort(detailVoList, "treeIndex");
                    res = TreeNodeBUtil.buildTree(detailVoList);
                }
            }
        }
        return res;
    }

    @RequestMapping(value={"/refTotalPlanDetailList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<Map>> refTotalPlanDetailList(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition, @RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(value="searchObject", required=false) String searchObject) {
        Map conditionMap;
        Page page = new Page();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.getFuzzyFields().add("materialTypeName");
        queryParam.getFuzzyFields().add("materialName");
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambd.eq(TotalPlanEntity::getProjectId, (Object)projectId);
            lambd.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
            lambd.in(TotalPlanEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            List list = this.totalPlanService.list((Wrapper)lambd);
            if (null != list && list.size() > 0) {
                Long totalId = ((TotalPlanEntity)((Object)list.get(0))).getId();
                queryParam.getParams().put("totalId", new Parameter("eq", (Object)totalId));
                List totalPlanDetailEntities = this.service.queryList(queryParam, false);
                List detailVoList = BeanMapper.mapList((Iterable)totalPlanDetailEntities, TotalPlanDetailVO.class);
                if (CollectionUtils.isNotEmpty((Collection)detailVoList)) {
                    new SortUtil().entryListToSort(detailVoList, "treeIndex");
                    List records = PageUtil.listToPage((List)detailVoList, (int)pageNumber, (int)pageSize);
                    List lists = BeanMapper.mapList((Iterable)records, Map.class);
                    for (Map map : lists) {
                        map.remove("children");
                    }
                    page.setRecords(lists);
                    page.setCurrent((long)pageNumber.intValue());
                    page.setSize((long)pageSize.intValue());
                    page.setTotal((long)detailVoList.size());
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

