/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.rmat.bean.ChangeClauseEntity;
import com.ejianc.business.pro.rmat.bean.ChangeDailyRentEntity;
import com.ejianc.business.pro.rmat.bean.ChangeEntity;
import com.ejianc.business.pro.rmat.bean.ChangeMonthRentEntity;
import com.ejianc.business.pro.rmat.bean.ChangeNumRentEntity;
import com.ejianc.business.pro.rmat.bean.ChangeOtherEntity;
import com.ejianc.business.pro.rmat.bean.ChangePaymentEntity;
import com.ejianc.business.pro.rmat.bean.ChangeRepairEntity;
import com.ejianc.business.pro.rmat.bean.ChangeScrapEntity;
import com.ejianc.business.pro.rmat.bean.ContractClauseEntity;
import com.ejianc.business.pro.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractNumRentEntity;
import com.ejianc.business.pro.rmat.bean.ContractOtherEntity;
import com.ejianc.business.pro.rmat.bean.ContractPaymentEntity;
import com.ejianc.business.pro.rmat.bean.ContractRepairEntity;
import com.ejianc.business.pro.rmat.bean.ContractScrapEntity;
import com.ejianc.business.pro.rmat.bean.RecordClauseEntity;
import com.ejianc.business.pro.rmat.bean.RecordDailyRentEntity;
import com.ejianc.business.pro.rmat.bean.RecordEntity;
import com.ejianc.business.pro.rmat.bean.RecordMonthRentEntity;
import com.ejianc.business.pro.rmat.bean.RecordNumRentEntity;
import com.ejianc.business.pro.rmat.bean.RecordOtherEntity;
import com.ejianc.business.pro.rmat.bean.RecordPaymentEntity;
import com.ejianc.business.pro.rmat.bean.RecordRepairEntity;
import com.ejianc.business.pro.rmat.bean.RecordScrapEntity;
import com.ejianc.business.pro.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.pro.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.pro.rmat.enums.ContractFilingTypeEnum;
import com.ejianc.business.pro.rmat.enums.DraftTypeEnum;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.pro.rmat.enums.SettleEnum;
import com.ejianc.business.pro.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.pro.rmat.mapper.ChangeMapper;
import com.ejianc.business.pro.rmat.service.IChangeService;
import com.ejianc.business.pro.rmat.service.IContractClauseService;
import com.ejianc.business.pro.rmat.service.IContractDailyRentService;
import com.ejianc.business.pro.rmat.service.IContractFileService;
import com.ejianc.business.pro.rmat.service.IContractMonthRentService;
import com.ejianc.business.pro.rmat.service.IContractNumRentService;
import com.ejianc.business.pro.rmat.service.IContractOtherService;
import com.ejianc.business.pro.rmat.service.IContractPaymentService;
import com.ejianc.business.pro.rmat.service.IContractRepairService;
import com.ejianc.business.pro.rmat.service.IContractScrapService;
import com.ejianc.business.pro.rmat.service.IContractService;
import com.ejianc.business.pro.rmat.service.IRecordService;
import com.ejianc.business.pro.rmat.vo.ChangeClauseVO;
import com.ejianc.business.pro.rmat.vo.ChangeCompareVO;
import com.ejianc.business.pro.rmat.vo.ChangeDailyRentVO;
import com.ejianc.business.pro.rmat.vo.ChangeMonthRentVO;
import com.ejianc.business.pro.rmat.vo.ChangeNumRentVO;
import com.ejianc.business.pro.rmat.vo.ChangeOtherVO;
import com.ejianc.business.pro.rmat.vo.ChangePaymentVO;
import com.ejianc.business.pro.rmat.vo.ChangeRepairVO;
import com.ejianc.business.pro.rmat.vo.ChangeScrapVO;
import com.ejianc.business.pro.rmat.vo.ChangeVO;
import com.ejianc.business.pro.rmat.vo.ContractVO;
import com.ejianc.business.pro.rmat.vo.RecordVO;
import com.ejianc.business.pro.rmat.vo.record.ChangeRecordVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.enums.RentTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="changeService")
public class ChangeServiceImpl
extends BaseServiceImpl<ChangeMapper, ChangeEntity>
implements IChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PRO_RMAT_CONTRACT_CHANGE = "PRO_RMAT_CONTRACT_CHANGE";
    private final String CONTRACT_REFCODE = "prormat_contract";
    private final String CONTRACT_RECORD_REFCODE = "prormat_contract_record";
    private final String CONTRACT_FILE_SOURCE_TYPE = "rmatContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "prormatContract";
    private static final String CHECK_PARAM_CODE = "P-858Y9N65";
    private final String HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-Y23zv60262";
    private final String HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-I57E2G0261";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractDailyRentService dailyRentService;
    @Autowired
    private IContractMonthRentService monthRentService;
    @Autowired
    private IContractNumRentService numRentService;
    @Autowired
    private IContractRepairService repairService;
    @Autowired
    private IContractScrapService scrapService;
    @Autowired
    private IContractOtherService otherService;
    @Autowired
    private IContractPaymentService paymentService;
    @Autowired
    private IContractClauseService clauseService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IContractFileService contractFileService;
    @Autowired
    private IShareMaterialApi materialApi;

    @Override
    public ChangeVO saveOrUpdate(ChangeVO saveOrUpdateVO, Boolean isControl) {
        ChangeEntity entity;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(saveOrUpdateVO.getMainContractId()));
        if (ListUtil.isNotEmpty((List)saveOrUpdateVO.getAttachIds()) && null != contractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(contractEntity.getContractFileId());
        }
        if ((entity = (ChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ChangeEntity.class))).getId() == null || entity.getId() == 0L) {
            entity.setId(IdWorker.getId());
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                entity.setChangeVersion(1);
            } else {
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }
            if (!isControl.booleanValue()) {
                if (entity.getChangeVersion() < 10) {
                    entity.setBillCode(entity.getMainContractCode() + "-1-0" + entity.getChangeVersion());
                } else {
                    entity.setBillCode(entity.getMainContractCode() + "-1-" + entity.getChangeVersion());
                }
            }
            this.clearDetailList(entity);
            if (!isControl.booleanValue()) {
                ChangeEntity oldEntity = this.queryChangeList(entity);
                ExecutionVO executionVO = null;
                executionVO = oldEntity == null ? this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class)) : this.targetCost((ChangeVO)BeanMapper.map((Object)((Object)oldEntity), ChangeVO.class));
                this.deleteTargetCost(executionVO);
            }
        }
        this.contractService.validateContract(saveOrUpdateVO.getMainContractId(), "\u53d8\u66f4\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        if (entity.getChangeFilingStatus() != null && Objects.equals(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode(), entity.getChangeFilingStatus())) {
            entity.setFilingRef(0);
        }
        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setChangeContractName(entity.getContractName());
        ChangeVO vo = null;
        if (!isControl.booleanValue()) {
            this.saveOrUpdate((Object)entity, false);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ContractEntity::getChangeId, (Object)entity.getId());
            updateWrapper.set(ContractEntity::getChangingMny, (Object)entity.getContractMny());
            updateWrapper.set(ContractEntity::getChangingTaxMny, (Object)entity.getContractTaxMny());
            updateWrapper.set(ContractEntity::getChangeCode, (Object)entity.getBillCode());
            updateWrapper.set(ContractEntity::getChangeVersion, (Object)entity.getChangeVersion());
            updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
            updateWrapper.set(ContractEntity::getChangeDate, (Object)entity.getChangeDate());
            updateWrapper.set(ContractEntity::getChangeDraftType, (Object)entity.getChangeDraftType());
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)entity.getSignatureStatus());
            updateWrapper.set(ContractEntity::getChangeFileId, (Object)entity.getChangeFileId());
            updateWrapper.set(ContractEntity::getChangeContractName, (Object)entity.getContractName());
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getMainContractId());
            this.contractService.update((Wrapper)updateWrapper);
            vo = (ChangeVO)BeanMapper.map((Object)this.selectById(entity.getId()), ChangeVO.class);
        } else {
            List<ChangeDailyRentEntity> dailyRentList = entity.getDailyRentList();
            List<ChangeMonthRentEntity> monthRentList = entity.getMonthRentList();
            List<ChangeNumRentEntity> numRentList = entity.getNumRentList();
            ArrayList<ChangeDailyRentEntity> newDailyRentList = new ArrayList<ChangeDailyRentEntity>();
            ArrayList<ChangeMonthRentEntity> newMonthRentList = new ArrayList<ChangeMonthRentEntity>();
            ArrayList<ChangeNumRentEntity> newNumRentList = new ArrayList<ChangeNumRentEntity>();
            for (ChangeDailyRentEntity dailyRentEntity : dailyRentList) {
                if (null == dailyRentEntity.getId()) {
                    dailyRentEntity.setId(IdWorker.getId());
                }
                if ("del".equals(dailyRentEntity.getRowState())) continue;
                newDailyRentList.add(dailyRentEntity);
            }
            for (ChangeMonthRentEntity monthRentEntity : monthRentList) {
                if (null == monthRentEntity.getId()) {
                    monthRentEntity.setId(IdWorker.getId());
                }
                if ("del".equals(monthRentEntity.getRowState())) continue;
                newMonthRentList.add(monthRentEntity);
            }
            for (ChangeNumRentEntity numRentEntity : numRentList) {
                if (null == numRentEntity.getId()) {
                    numRentEntity.setId(IdWorker.getId());
                }
                if ("del".equals(numRentEntity.getRowState())) continue;
                newNumRentList.add(numRentEntity);
            }
            vo = (ChangeVO)BeanMapper.map((Object)((Object)entity), ChangeVO.class);
            vo.setDailyRentList(BeanMapper.mapList(newDailyRentList, ChangeDailyRentVO.class));
            vo.setMonthRentList(BeanMapper.mapList(newMonthRentList, ChangeMonthRentVO.class));
            vo.setNumRentList(BeanMapper.mapList(newNumRentList, ChangeNumRentVO.class));
        }
        if (!isControl.booleanValue()) {
            this.logger.info("\u63a8\u9001\u76ee\u6807\u6210\u672c\uff1a" + JSONObject.toJSONString((Object)this.targetCost(vo)));
            CommonResponse response = this.executionApi.aggPush(this.targetCost(vo));
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25\uff01");
            }
        }
        return (ChangeVO)BeanMapper.map((Object)((Object)entity), ChangeVO.class);
    }

    @Override
    public ChangeRecordVO queryChangeRecord(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        ChangeRecordVO vo = new ChangeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setBaseMny(entity.getBaseMny());
        vo.setBaseTaxMny(entity.getBaseTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        vo.setRentType(entity.getRentType());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ChangeEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List changeList = super.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)changeList)) {
            ChangeEntity changeEntity = (ChangeEntity)((Object)changeList.get(0));
            vo.setTotalChangeMny(ComputeUtil.safeSub((BigDecimal)changeEntity.getContractMny(), (BigDecimal)vo.getBaseMny()));
            vo.setTotalChangeTaxMny(ComputeUtil.safeSub((BigDecimal)changeEntity.getContractTaxMny(), (BigDecimal)vo.getBaseTaxMny()));
            vo.setTotalChangeNum(Integer.valueOf(changeList.size()));
            vo.setTotalChangeRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalChangeTaxMny(), (BigDecimal)vo.getBaseTaxMny()), (BigDecimal)new BigDecimal("100")));
        }
        vo.setDetailList(BeanMapper.mapList((Iterable)changeList, ChangeVO.class));
        Boolean contractFilingFlag = this.contractService.checkFilingType(id, ContractFilingTypeEnum.\u79df\u8d41\u5408\u540c\u53d8\u66f4.getTypeCode());
        if (contractFilingFlag.booleanValue()) {
            vo.setCanAddNewChangeFlag(true);
        } else {
            vo.setCanAddNewChangeFlag(false);
        }
        return vo;
    }

    @Override
    public RecordVO queryContractRecordDetail(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RecordEntity::getChangeId, (Object)id);
        List list = this.recordService.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            return (RecordVO)BeanMapper.map((Object)this.recordService.selectById(((RecordEntity)((Object)list.get(0))).getId()), RecordVO.class);
        }
        return new RecordVO();
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.selectById(changeBillId));
        ContractVO contractVO = this.contractService.queryDetail(changeEntity.getContractId());
        this.writeBackRecord(changeEntity, contractVO);
        this.writeBackContract(changeEntity, contractVO);
        changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setCommitDate(new Date());
        this.changeService.saveOrUpdate((Object)changeEntity);
        if ((DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(changeEntity.getChangeDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().equals(changeEntity.getChangeDraftType())) && "0".equals(changeEntity.getRentType())) {
            this.contractFileService.getSignedFileInfo(changeBillId, "contractChange");
        }
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public void deleteByIds(List<ChangeVO> vos) {
        for (ChangeVO vo : vos) {
            ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            this.deleteTargetCost(this.targetCost((ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class)));
            ChangeEntity oldEntity = this.queryChangeList(changeEntity);
            ExecutionVO executionVO = null;
            if (oldEntity == null) {
                ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
                executionVO = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
            } else {
                executionVO = this.targetCost((ChangeVO)BeanMapper.map((Object)((Object)oldEntity), ChangeVO.class));
            }
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25\uff01");
            }
            LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
            if (changeEntity.getChangeVersion() == 1) {
                lambdaUpdate.set(ContractEntity::getChangeStatus, (Object)1);
            } else {
                lambdaUpdate.set(ContractEntity::getChangeStatus, (Object)3);
            }
            lambdaUpdate.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            this.contractService.update((Wrapper)lambdaUpdate);
            super.removeById((Serializable)vo, false);
        }
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.selectById(id));
        ChangeCompareVO changeCompareVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), ChangeCompareVO.class);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        boolean flag = false;
        if ((BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(changeEntity.getBillState())) && Objects.equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString(), contractEntity.getChangeContractSignatureStatus())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(RecordEntity::getChangeId, (Object)id);
            wrapper.eq(RecordEntity::getContractId, (Object)changeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List recordEntityList = this.recordService.list((Wrapper)wrapper);
            if (ListUtil.isNotEmpty((List)recordEntityList)) {
                beforeChangeVO = (ChangeCompareVO)BeanMapper.map((Object)this.recordService.selectById(((RecordEntity)((Object)recordEntityList.get(0))).getId()), ChangeCompareVO.class);
            }
        } else {
            beforeChangeVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)contractEntity), ChangeCompareVO.class);
            flag = true;
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            ChangeDailyRentVO beforeVO;
            if (ListUtil.isNotEmpty((List)changeCompareVO.getDailyRentList())) {
                List dailyRentList = beforeChangeVO.getDailyRentList();
                Map<Object, Object> beforeDailyMap = new HashMap();
                beforeDailyMap = flag ? dailyRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : dailyRentList.stream().collect(Collectors.toMap(ChangeDailyRentVO::getSourceBid, Function.identity()));
                for (Object vo : changeCompareVO.getDailyRentList()) {
                    if (!StringUtils.isNotEmpty((String)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeDailyRentVO)beforeDailyMap.get(vo.getSourceBid());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                    vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcStartDate(beforeVO.getStartDate());
                    vo.setBcEndDate(beforeVO.getEndDate());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setBcRentDays(beforeVO.getRentDays());
                    vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                }
                changeCompareVO.setDailyRentList(changeCompareVO.getDailyRentList().stream().filter(daily -> StringUtils.isNotEmpty((String)daily.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getMonthRentList())) {
                List monthRentList = beforeChangeVO.getMonthRentList();
                Map<Object, Object> beforeMonthMap = new HashMap();
                beforeMonthMap = flag ? monthRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : monthRentList.stream().collect(Collectors.toMap(ChangeMonthRentVO::getSourceBid, Function.identity()));
                for (Object vo : changeCompareVO.getMonthRentList()) {
                    if (!StringUtils.isNotEmpty((String)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeMonthRentVO)beforeMonthMap.get(vo.getSourceBid());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcLackMonthDayUnitTaxPrice(beforeVO.getLackMonthDayUnitTaxPrice());
                    vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                    vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcStartDate(beforeVO.getStartDate());
                    vo.setBcEndDate(beforeVO.getEndDate());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setBcRentMonths(beforeVO.getRentMonths());
                    vo.setBcRentDays(beforeVO.getRentDays());
                    vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                }
                changeCompareVO.setMonthRentList(changeCompareVO.getMonthRentList().stream().filter(month -> StringUtils.isNotEmpty((String)month.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getNumRentList())) {
                List numRentList = beforeChangeVO.getNumRentList();
                Map<Object, Object> beforeNumMap = new HashMap();
                beforeNumMap = flag ? numRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : numRentList.stream().collect(Collectors.toMap(ChangeNumRentVO::getSourceBid, Function.identity()));
                for (Object vo : changeCompareVO.getNumRentList()) {
                    if (!StringUtils.isNotEmpty((String)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeNumRentVO)beforeNumMap.get(vo.getSourceBid());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcStartDate(beforeVO.getStartDate());
                    vo.setBcEndDate(beforeVO.getEndDate());
                    vo.setBcMemo(beforeVO.getMemo());
                    vo.setBcQuantities(beforeVO.getQuantities());
                    vo.setBcRentTaxMny(beforeVO.getRentTaxMny());
                }
                changeCompareVO.setNumRentList(changeCompareVO.getNumRentList().stream().filter(num -> StringUtils.isNotEmpty((String)num.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getRepairList())) {
                List repairList = beforeChangeVO.getRepairList();
                Map<Object, Object> beforeRepairMap = new HashMap();
                beforeRepairMap = flag ? repairList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : repairList.stream().collect(Collectors.toMap(ChangeRepairVO::getSourceBid, Function.identity()));
                for (Object vo : changeCompareVO.getRepairList()) {
                    if (!StringUtils.isNotEmpty((String)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeRepairVO)beforeRepairMap.get(vo.getSourceBid());
                    vo.setBcRepairItemName(beforeVO.getRepairItemName());
                    vo.setBcRepairUnitName(beforeVO.getRepairUnitName());
                    vo.setBcRepairTaxPrice(beforeVO.getRepairTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setRepairList(changeCompareVO.getRepairList().stream().filter(repair -> StringUtils.isNotEmpty((String)repair.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getScrapList())) {
                List scrapList = beforeChangeVO.getScrapList();
                Map<Object, Object> beforeScrapMap = new HashMap();
                beforeScrapMap = flag ? scrapList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : scrapList.stream().collect(Collectors.toMap(ChangeScrapVO::getSourceBid, Function.identity()));
                for (Object vo : changeCompareVO.getScrapList()) {
                    if (!StringUtils.isNotEmpty((String)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeScrapVO)beforeScrapMap.get(vo.getSourceBid());
                    vo.setBcDamageScrapName(beforeVO.getDamageScrapName());
                    vo.setBcDamageScrapUnitName(beforeVO.getDamageScrapUnitName());
                    vo.setBcDamageScrapTaxPrice(beforeVO.getDamageScrapTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setScrapList(changeCompareVO.getScrapList().stream().filter(scarp -> StringUtils.isNotEmpty((String)scarp.getChangeType())).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getOtherList())) {
                List otherList = beforeChangeVO.getOtherList();
                Map<Object, Object> beforeOtherMap = new HashMap();
                beforeOtherMap = flag ? otherList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())) : otherList.stream().collect(Collectors.toMap(ChangeOtherVO::getSourceBid, Function.identity()));
                for (Object vo : changeCompareVO.getOtherList()) {
                    if (!StringUtils.isNotEmpty((String)vo.getChangeType()) || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeOtherVO)beforeOtherMap.get(vo.getSourceBid());
                    vo.setBcCostName(beforeVO.getCostName());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(BigDecimal.ZERO);
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setOtherList(changeCompareVO.getOtherList().stream().filter(other -> StringUtils.isNotEmpty((String)other.getChangeType())).collect(Collectors.toList()));
            }
            ArrayList<ChangePaymentVO> newPayList = new ArrayList<ChangePaymentVO>();
            Map<Object, Object> beforePayMap = new HashMap();
            beforePayMap = flag ? beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(BaseVO::getId, item -> item, (v1, v2) -> v2)) : beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(ChangePaymentVO::getSourceBid, item -> item, (v1, v2) -> v2));
            if (ListUtil.isNotEmpty((List)changeCompareVO.getPaymentList())) {
                ChangePaymentVO beforeVo = null;
                for (ChangePaymentVO vo : changeCompareVO.getPaymentList()) {
                    if (vo.getSourceBid() == null) {
                        vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_ADD.toString());
                        newPayList.add(vo);
                        continue;
                    }
                    if (!beforePayMap.containsKey(vo.getSourceBid())) continue;
                    beforeVo = (ChangePaymentVO)beforePayMap.get(vo.getSourceBid());
                    if (!beforeVo.getPaymentName().equals(vo.getPaymentName()) || !beforeVo.getPaymentScale().equals(vo.getPaymentScale())) {
                        vo.setBcPaymentName(beforeVo.getPaymentName());
                        vo.setBcPaymentScale(beforeVo.getPaymentScale());
                        vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                        newPayList.add(vo);
                    }
                    beforePayMap.remove(vo.getSourceBid());
                }
            }
            if (MapUtils.isNotEmpty(beforePayMap)) {
                beforePayMap.values().forEach(c -> {
                    c.setChangeType(ChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newPayList.add((ChangePaymentVO)c);
                });
            }
            changeCompareVO.setPaymentList(newPayList);
            ArrayList<ChangeClauseVO> newClauses = new ArrayList<ChangeClauseVO>();
            Map<Object, Object> beforeClauseMap = new HashMap();
            beforeClauseMap = flag ? beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(BaseVO::getId, clause -> clause, (v1, v2) -> v2)) : beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(ChangeClauseVO::getSourceBid, clause -> clause, (v1, v2) -> v2));
            if (ListUtil.isNotEmpty((List)changeCompareVO.getClauseList())) {
                ChangeClauseVO beforeVo = null;
                for (ChangeClauseVO vo : changeCompareVO.getClauseList()) {
                    if (vo.getSourceBid() == null) {
                        vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_ADD.toString());
                        newClauses.add(vo);
                        continue;
                    }
                    if (!beforeClauseMap.containsKey(vo.getSourceBid())) continue;
                    beforeVo = (ChangeClauseVO)beforeClauseMap.get(vo.getSourceBid());
                    if (!Objects.equals(beforeVo.getClauseNameId(), vo.getClauseNameId()) || !Objects.equals(beforeVo.getClauseContent(), vo.getClauseContent())) {
                        vo.setBcClauseName(beforeVo.getClauseName());
                        vo.setBcClauseContent(beforeVo.getClauseContent());
                        vo.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                        newClauses.add(vo);
                    }
                    beforeClauseMap.remove(vo.getSourceBid());
                }
            }
            if (MapUtils.isNotEmpty(beforeClauseMap)) {
                beforeClauseMap.values().forEach(c -> {
                    c.setChangeType(ChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newClauses.add((ChangeClauseVO)c);
                });
            }
            changeCompareVO.setClauseList(newClauses);
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    @Override
    public Boolean pushContract(ContractVO vo, String updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            this.contractService.delContractFromPool(vo.getId());
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            String cardType = vo.getAddType() == 0 ? "targetCard" : "addCard";
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-prormat-frontend/#/contract/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus() : "/ejc-prormat-frontend/#/contract/supplementCard?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            data.setPcCardUrl(url);
            ChangeRecordVO changeRecordVO = this.queryChangeRecord(vo.getId());
            data.setTotalChangeMny(changeRecordVO.getTotalChangeMny());
            data.setTotalChangeTaxMny(changeRecordVO.getTotalChangeTaxMny());
            data.setTotalChangeTax(ComputeUtil.safeSub((BigDecimal)data.getTotalChangeTaxMny(), (BigDecimal)data.getTotalChangeMny()));
            data.setTaotalChangeScale(changeRecordVO.getTotalChangeRate());
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return null;
    }

    public void writeBackRecord(ChangeEntity changeEntity, ContractVO contractVO) {
        RecordEntity recordEntity = (RecordEntity)((Object)BeanMapper.map((Object)contractVO, RecordEntity.class));
        recordEntity.setContractId(changeEntity.getContractId());
        recordEntity.setId(null);
        if (ListUtil.isNotEmpty(recordEntity.getDailyRentList())) {
            for (RecordDailyRentEntity recordDailyRentEntity : recordEntity.getDailyRentList()) {
                recordDailyRentEntity.setSourceBid(recordDailyRentEntity.getId());
                recordDailyRentEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getMonthRentList())) {
            for (RecordMonthRentEntity recordMonthRentEntity : recordEntity.getMonthRentList()) {
                recordMonthRentEntity.setSourceBid(recordMonthRentEntity.getId());
                recordMonthRentEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getNumRentList())) {
            for (RecordNumRentEntity recordNumRentEntity : recordEntity.getNumRentList()) {
                recordNumRentEntity.setSourceBid(recordNumRentEntity.getId());
                recordNumRentEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getRepairList())) {
            for (RecordRepairEntity recordRepairEntity : recordEntity.getRepairList()) {
                recordRepairEntity.setSourceBid(recordRepairEntity.getId());
                recordRepairEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getScrapList())) {
            for (RecordScrapEntity recordScrapEntity : recordEntity.getScrapList()) {
                recordScrapEntity.setSourceBid(recordScrapEntity.getId());
                recordScrapEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getOtherList())) {
            for (RecordOtherEntity recordOtherEntity : recordEntity.getOtherList()) {
                recordOtherEntity.setSourceBid(recordOtherEntity.getId());
                recordOtherEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getClauseList())) {
            for (RecordClauseEntity recordClauseEntity : recordEntity.getClauseList()) {
                recordClauseEntity.setSourceBid(recordClauseEntity.getId());
                recordClauseEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getPaymentList())) {
            for (RecordPaymentEntity recordPaymentEntity : recordEntity.getPaymentList()) {
                recordPaymentEntity.setSourceBid(recordPaymentEntity.getId());
                recordPaymentEntity.setId(null);
            }
        }
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        if ("0".equals(changeEntity.getRentType()) || StringUtils.isEmpty((String)changeEntity.getRentType())) {
            this.logger.info("\u540c\u6b65\u9644\u4ef6");
            CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractVO.getId()), "BT220210000000004", "prormatContract", String.valueOf(recordEntity.getId()), "BT220210000000006", "prormatContractRecord");
            this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
            this.logger.info("\u540c\u6b65\u9644\u4ef6");
            CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractVO.getId()), "BT220210000000004", "rmatContractFile", String.valueOf(recordEntity.getId()), "BT220210000000006", "rmatContractRecordFile");
            this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)commonResponse));
        }
    }

    public void writeBackContract(ChangeEntity changeEntity, ContractVO contractVO) {
        List clauseList;
        List paymentList;
        List otherList;
        List scrapList;
        List repairList;
        List numRentList;
        List monthRentList;
        List dailyRentList;
        ContractEntity contractEntity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyEmployeeId(changeEntity.getFirstPartyEmployeeId());
        contractEntity.setFirstPartyEmployeeName(changeEntity.getFirstPartyEmployeeName());
        contractEntity.setFirstPartyPhone(changeEntity.getFirstPartyPhone());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierEmployeeId(changeEntity.getSupplierEmployeeId());
        contractEntity.setSupplierEmployeeName(changeEntity.getSupplierEmployeeName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplierAddress(changeEntity.getSupplierAddress());
        contractEntity.setPurchaseId(changeEntity.getPurchaseId());
        contractEntity.setPurchaseName(changeEntity.getPurchaseName());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setTax(changeEntity.getTax());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        contractEntity.setDetailTaxMny(changeEntity.getDetailTaxMny());
        contractEntity.setDetailMny(changeEntity.getDetailMny());
        contractEntity.setDetailTax(changeEntity.getDetailTax());
        contractEntity.setOtherTaxMny(changeEntity.getOtherTaxMny());
        contractEntity.setOtherMny(changeEntity.getOtherMny());
        contractEntity.setOtherTax(changeEntity.getOtherTax());
        contractEntity.setRentCalculationType(changeEntity.getRentCalculationType());
        contractEntity.setMonthSettlementDay(changeEntity.getMonthSettlementDay());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setChangeContractName(changeEntity.getContractName());
        contractEntity.setSupplyAddress(changeEntity.getSupplyAddress());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setRentCalculationDate(changeEntity.getRentCalculationDate());
        contractEntity.setEndRentCalculationDate(changeEntity.getEndRentCalculationDate());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangeVersion(changeEntity.getChangeVersion());
        contractEntity.setChangeContractSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString());
        contractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        contractEntity.setChangeFileId(changeEntity.getChangeFileId());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        if (ListUtil.isNotEmpty((List)contractVO.getDailyRentList())) {
            this.dailyRentService.removeByIds(contractVO.getDailyRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(dailyRentList = BeanMapper.mapList(changeEntity.getDailyRentList(), ContractDailyRentEntity.class)))) {
            for (Object entity : dailyRentList) {
                ((ContractDailyRentEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractDailyRentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setDailyRentList(dailyRentList);
        if (ListUtil.isNotEmpty((List)contractVO.getMonthRentList())) {
            this.monthRentService.removeByIds(contractVO.getMonthRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(monthRentList = BeanMapper.mapList(changeEntity.getMonthRentList(), ContractMonthRentEntity.class)))) {
            for (Object entity : monthRentList) {
                ((ContractMonthRentEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractMonthRentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setMonthRentList(monthRentList);
        if (ListUtil.isNotEmpty((List)contractVO.getNumRentList())) {
            this.numRentService.removeByIds(contractVO.getNumRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(numRentList = BeanMapper.mapList(changeEntity.getNumRentList(), ContractNumRentEntity.class)))) {
            for (Object entity : numRentList) {
                ((ContractNumRentEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractNumRentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setNumRentList(numRentList);
        if (ListUtil.isNotEmpty((List)contractVO.getRepairList())) {
            this.repairService.removeByIds(contractVO.getRepairList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(repairList = BeanMapper.mapList(changeEntity.getRepairList(), ContractRepairEntity.class)))) {
            for (Object entity : repairList) {
                ((ContractRepairEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractRepairEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRepairList(repairList);
        if (ListUtil.isNotEmpty((List)contractVO.getScrapList())) {
            this.scrapService.removeByIds(contractVO.getScrapList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(scrapList = BeanMapper.mapList(changeEntity.getScrapList(), ContractScrapEntity.class)))) {
            for (Object entity : scrapList) {
                ((ContractScrapEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractScrapEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setScrapList(scrapList);
        if (ListUtil.isNotEmpty((List)contractVO.getOtherList())) {
            this.otherService.removeByIds(contractVO.getOtherList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(otherList = BeanMapper.mapList(changeEntity.getOtherList(), ContractOtherEntity.class)))) {
            for (Object entity : otherList) {
                ((ContractOtherEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractOtherEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setOtherList(otherList);
        if (ListUtil.isNotEmpty((List)contractVO.getPaymentList())) {
            this.paymentService.removeByIds(contractVO.getPaymentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(paymentList = BeanMapper.mapList(changeEntity.getPaymentList(), ContractPaymentEntity.class)))) {
            for (Object entity : paymentList) {
                ((ContractPaymentEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractPaymentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setPaymentList(paymentList);
        if (ListUtil.isNotEmpty((List)contractVO.getClauseList())) {
            this.clauseService.removeByIds(contractVO.getClauseList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(clauseList = BeanMapper.mapList(changeEntity.getClauseList(), ContractClauseEntity.class)))) {
            for (ContractClauseEntity entity : clauseList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setClauseList(clauseList);
        Boolean pushResult = this.pushContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), UpdateLevelEnum.\u5168\u91cf\u8986\u76d6\u66f4\u65b0.getLevelCode());
        if (pushResult.booleanValue()) {
            contractEntity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            contractEntity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        if ("0".equals(changeEntity.getRentType()) || StringUtils.isEmpty((String)changeEntity.getRentType())) {
            this.logger.info("\u540c\u6b65\u9644\u4ef6");
            CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeEntity.getId()), "BT220210000000005", "rmatChangeContractFile", String.valueOf(contractEntity.getId()), "BT220210000000004", "prormatContract");
            this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
        }
    }

    public void clearDetailList(ChangeEntity changeEntity) {
        if (ListUtil.isNotEmpty(changeEntity.getDailyRentList())) {
            for (ChangeDailyRentEntity changeDailyRentEntity : changeEntity.getDailyRentList()) {
                if (changeDailyRentEntity.getId() != null) {
                    changeDailyRentEntity.setSourceBid(changeDailyRentEntity.getId());
                }
                changeDailyRentEntity.setId(null);
                changeDailyRentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getMonthRentList())) {
            for (ChangeMonthRentEntity changeMonthRentEntity : changeEntity.getMonthRentList()) {
                if (changeMonthRentEntity.getId() != null) {
                    changeMonthRentEntity.setSourceBid(changeMonthRentEntity.getId());
                }
                changeMonthRentEntity.setId(null);
                changeMonthRentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getNumRentList())) {
            for (ChangeNumRentEntity changeNumRentEntity : changeEntity.getNumRentList()) {
                if (changeNumRentEntity.getId() != null) {
                    changeNumRentEntity.setSourceBid(changeNumRentEntity.getId());
                }
                changeNumRentEntity.setId(null);
                changeNumRentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getRepairList())) {
            for (ChangeRepairEntity changeRepairEntity : changeEntity.getRepairList()) {
                if (changeRepairEntity.getId() != null) {
                    changeRepairEntity.setSourceBid(changeRepairEntity.getId());
                }
                changeRepairEntity.setId(null);
                changeRepairEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getScrapList())) {
            for (ChangeScrapEntity changeScrapEntity : changeEntity.getScrapList()) {
                if (changeScrapEntity.getId() != null) {
                    changeScrapEntity.setSourceBid(changeScrapEntity.getId());
                }
                changeScrapEntity.setId(null);
                changeScrapEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getOtherList())) {
            for (ChangeOtherEntity changeOtherEntity : changeEntity.getOtherList()) {
                if (changeOtherEntity.getId() != null) {
                    changeOtherEntity.setSourceBid(changeOtherEntity.getId());
                }
                changeOtherEntity.setId(null);
                changeOtherEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getPaymentList())) {
            for (ChangePaymentEntity changePaymentEntity : changeEntity.getPaymentList()) {
                if (changePaymentEntity.getId() != null) {
                    changePaymentEntity.setSourceBid(changePaymentEntity.getId());
                }
                changePaymentEntity.setId(null);
                changePaymentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getClauseList())) {
            for (ChangeClauseEntity changeClauseEntity : changeEntity.getClauseList()) {
                if (changeClauseEntity.getId() != null) {
                    changeClauseEntity.setSourceBid(changeClauseEntity.getId());
                }
                changeClauseEntity.setId(null);
                changeClauseEntity.setContractId(changeEntity.getMainContractId());
            }
        }
    }

    public void deleteTargetCost(ExecutionVO executionVO) {
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        totalExecutionVOList.add(executionVO.getTotalVO());
        this.logger.info("\u5220\u9664\u76ee\u6807\u6210\u672c\uff1a" + JSONObject.toJSONString(totalExecutionVOList));
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u5220\u9664\u65e7\u76ee\u6807\u6210\u672c\u5931\u8d25\uff01");
        }
    }

    @Override
    public ExecutionVO targetCost(ChangeVO changeVO) {
        List monthRentList;
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setContractId(changeVO.getId());
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setMemo(changeVO.getMemo());
        totalVO.setProjectId(changeVO.getProjectId());
        totalVO.setSourceId(changeVO.getId());
        totalVO.setTenantId(changeVO.getTenantId());
        totalVO.setBillCode(changeVO.getBillCode());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)changeVO.getSignDate()));
        totalVO.setBillType("BT220210000000005");
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(changeVO.getProjectId());
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setMoney(changeVO.getContractMny());
        totalVO.setTaxMoney(changeVO.getContractTaxMny());
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        totalVO.setLinkUrl(frontendBaseHost + "ejc-prormat-frontend/#/contract/changeCard?id=" + changeVO.getId());
        List dailyRentList = changeVO.getDailyRentList();
        if (dailyRentList != null) {
            for (ChangeDailyRentVO dailyRent : dailyRentList) {
                if ("del".equals(dailyRent.getRowState())) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(dailyRent.getId() == null ? IdWorker.getId() : dailyRent.getId()));
                detailExecutionVO.setSourceBillId(changeVO.getId());
                detailExecutionVO.setCategoryId(dailyRent.getMaterialTypeId());
                detailExecutionVO.setCategoryName(dailyRent.getMaterialTypeName());
                if (dailyRent.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(dailyRent.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(dailyRent.getMaterialId());
                }
                detailExecutionVO.setCode(dailyRent.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(dailyRent.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setUnitId(dailyRent.getUnitId());
                detailExecutionVO.setUnitName(dailyRent.getUnitName());
                detailExecutionVO.setName(dailyRent.getMaterialName());
                detailExecutionVO.setNum(dailyRent.getCount());
                detailExecutionVO.setMoney(dailyRent.getRentMny());
                detailExecutionVO.setSpec(dailyRent.getSpec());
                detailExecutionVO.setTaxMoney(dailyRent.getRentTaxMny());
                detailExecutionVO.setPrice(dailyRent.getUnitPrice());
                detailExecutionVO.setTaxPrice(dailyRent.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(dailyRent.getTax());
                detailExecutionVO.setContractId(changeVO.getId());
                detailExecutionVO.setRentDayNum(dailyRent.getRentDays() == null ? BigDecimal.ZERO : new BigDecimal(dailyRent.getRentDays().toString()));
                detailExecutionVO.setRentType(RentTypeEnum.\u65e5\u79df.getCode());
                detailExecutionVO.setContractDetailId(dailyRent.getId());
                detailList.add(detailExecutionVO);
            }
        }
        if ((monthRentList = changeVO.getMonthRentList()) != null) {
            for (ChangeMonthRentVO monthRentVO : monthRentList) {
                if ("del".equals(monthRentVO.getRowState())) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId()));
                detailExecutionVO.setSourceBillId(changeVO.getId());
                detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                if (monthRentVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                }
                detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                detailExecutionVO.setName(monthRentVO.getMaterialName());
                detailExecutionVO.setNum(monthRentVO.getCount());
                detailExecutionVO.setMoney(monthRentVO.getRentMny());
                detailExecutionVO.setSpec(monthRentVO.getSpec());
                detailExecutionVO.setTaxMoney(monthRentVO.getRentTaxMny());
                detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(monthRentVO.getTax());
                detailExecutionVO.setContractId(changeVO.getId());
                detailExecutionVO.setRentDayNum(monthRentVO.getRentDays() == null ? BigDecimal.ZERO : new BigDecimal(monthRentVO.getRentDays().toString()));
                detailExecutionVO.setRentMonthNum(monthRentVO.getRentMonths() == null ? BigDecimal.ZERO : new BigDecimal(monthRentVO.getRentMonths().toString()));
                detailExecutionVO.setRentType(RentTypeEnum.\u6708\u79df.getCode());
                detailExecutionVO.setContractDetailId(monthRentVO.getId());
                detailList.add(detailExecutionVO);
            }
        }
        List numRentList = changeVO.getNumRentList();
        if (monthRentList != null) {
            for (ChangeNumRentVO monthRentVO : numRentList) {
                if ("del".equals(monthRentVO.getRowState())) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(monthRentVO.getId() == null ? IdWorker.getId() : monthRentVO.getId()));
                detailExecutionVO.setSourceBillId(changeVO.getId());
                detailExecutionVO.setCategoryId(monthRentVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(monthRentVO.getMaterialTypeName());
                if (monthRentVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(monthRentVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(monthRentVO.getMaterialId());
                }
                detailExecutionVO.setCode(monthRentVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(monthRentVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(monthRentVO.getMaterialName());
                detailExecutionVO.setUnitId(monthRentVO.getUnitId());
                detailExecutionVO.setUnitName(monthRentVO.getUnitName());
                detailExecutionVO.setNum(monthRentVO.getCount());
                detailExecutionVO.setMoney(monthRentVO.getRentMny());
                detailExecutionVO.setSpec(monthRentVO.getSpec());
                detailExecutionVO.setTaxMoney(monthRentVO.getRentTaxMny());
                detailExecutionVO.setPrice(monthRentVO.getUnitPrice());
                detailExecutionVO.setTaxPrice(monthRentVO.getUnitTaxPrice());
                detailExecutionVO.setTaxRate(monthRentVO.getTax());
                detailExecutionVO.setContractId(changeVO.getId());
                detailExecutionVO.setRentType(RentTypeEnum.\u5de5\u7a0b\u91cf\u79df.getCode());
                detailExecutionVO.setQuantityNum(monthRentVO.getQuantities());
                detailExecutionVO.setContractDetailId(monthRentVO.getId());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ChangeVO changeVO) {
        ChangeVO vo = this.saveOrUpdate(changeVO, true);
        ExecutionVO executionVO = this.targetCost(vo);
        TotalExecutionVO totalVO = executionVO.getTotalVO();
        if (null == changeVO.getId()) {
            ChangeEntity entity = (ChangeEntity)((Object)BeanMapper.map((Object)changeVO, ChangeEntity.class));
            ChangeEntity oldEntity = this.queryChangeList(entity);
            if (oldEntity == null) {
                totalVO.setLastSourceId(changeVO.getMainContractId());
            } else {
                totalVO.setLastSourceId(oldEntity.getId());
            }
        }
        executionVO.setTotalVO(totalVO);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        return (ParamsCheckVO)response.getData();
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ChangeEntity entity = (ChangeEntity)((Object)this.selectById(id));
        ChangeVO vo = (ChangeVO)BeanMapper.map((Object)((Object)entity), ChangeVO.class);
        ExecutionVO executionVO = this.targetCost(vo);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        return (ParamsCheckVO)response.getData();
    }

    @Override
    public ParamsCheckVO changeCheckParams(ChangeVO vo) {
        ChangeVO changeVO = this.saveOrUpdate(vo, true);
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        paramsCheckVOS.addAll(this.checkParamsChangeMny(changeVO.getId(), changeVO.getMainContractId(), changeVO.getChangeMny()));
        ParamsCheckVO costParams = this.costPriceCheckParams(changeVO);
        if (costParams != null) {
            paramsCheckVOS.add(costParams);
        }
        paramsCheckVOS.addAll(this.changeService.historyPriceCtrlContractPrice(vo));
        ParamsCheckVO paramsCheckVO1 = this.targetCostCtrl(changeVO);
        if (null != paramsCheckVO1) {
            paramsCheckVOS.add(paramsCheckVO1);
        }
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(ChangeVO contractVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        this.logger.info("proequipment---RentContractServiceImpl---historyPriceCtrlContractPrice()--- \u5386\u53f2\u4ef7\u63a7\u5408\u540c\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse maxParamByCode = new CommonResponse();
        CommonResponse minParamByCode = new CommonResponse();
        List dayDetailList = contractVO.getDailyRentList();
        List monthDetailList = contractVO.getMonthRentList();
        List quantitiesDetailList = contractVO.getNumRentList();
        maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-Y23zv60262", contractVO.getOrgId());
        minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-I57E2G0261", contractVO.getOrgId());
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u5386\u53f2\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c\u5386\u53f2\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        boolean flag = true;
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)PrinceDepotEnum.\u5468\u8f6c\u6750\u4ef7\u683c\u5e93.getCode()));
        CommonResponse commonResponse = this.priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.\u5468\u8f6c\u6750\u4ef7\u683c\u5e93.getCode());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        List data = (List)commonResponse.getData();
        Integer priorityFlag = ((PriceDepotParamSetDTO)data.get(0)).getPriorityFlag();
        if (null != priorityFlag && 2 == priorityFlag) {
            flag = false;
        }
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                BigDecimal maxPriceParam;
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (ChangeDailyRentVO detailVO : dayDetailList) {
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u660e\u7ec6\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getUnitPrice() == null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u65e5\u79df\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u65e5\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                for (ChangeDailyRentVO detailVO : monthDetailList) {
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getUnitPrice() == null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u6708\u79df\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6708\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                for (ChangeDailyRentVO detailVO : quantitiesDetailList) {
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getUnitPrice() == null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u5de5\u7a0b\u91cf\u79df\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5de5\u7a0b\u91cf\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                BigDecimal minPriceParam;
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                if ("none".equals(paramsArray[minParamVO.getControlType()])) continue;
                for (ChangeDailyRentVO detailVO : dayDetailList) {
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getUnitPrice() == null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u65e5\u79df\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u65e5\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                for (ChangeDailyRentVO detailVO : monthDetailList) {
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getUnitPrice() == null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u6708\u79df\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6708\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                for (ChangeDailyRentVO detailVO : quantitiesDetailList) {
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getUnitPrice() == null ? BigDecimal.ZERO : detailVO.getUnitPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u5de5\u7a0b\u91cf\u79df\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5de5\u7a0b\u91cf\u79df\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }
        return paramsCheckVOList;
    }

    private List<ParamsCheckVO> checkParamsChangeMny(Long id, Long mainContractId, BigDecimal changeMny) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(mainContractId));
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, contractEntity.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractEntity.getBaseTaxMny(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(ChangeEntity::getMainContractId, (Object)mainContractId);
                    queryWrapper.in(ChangeEntity::getBillState, new Object[]{1, 3});
                    queryWrapper.eq(BaseEntity::getDr, (Object)0);
                    queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    List changeList = super.list((Wrapper)queryWrapper);
                    BigDecimal sumChangeTaxMny = BigDecimal.ZERO;
                    if (CollectionUtils.isNotEmpty((Collection)changeList)) {
                        sumChangeTaxMny = changeList.stream().map(ChangeEntity::getChangeMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    sumChangeTaxMny = ComputeUtil.safeAdd((BigDecimal)sumChangeTaxMny, (BigDecimal)changeMny).setScale(2, 4);
                    BigDecimal bigDecimal = changeMny = changeMny != null ? changeMny.setScale(2, 4) : BigDecimal.ZERO;
                    if (sumChangeTaxMny.compareTo(comMny) <= 0) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u53d8\u66f4\u8d85\u5408\u540c\u91d1\u989d");
                    paramsCheckDsVO.setOrgName(datum.getOrgName());
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff1a").append(changeMny).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff1a").append(sumChangeTaxMny).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumChangeTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    public ParamsCheckVO costPriceCheckParams(ChangeVO vo) {
        MaterialCostPriceApiVO priceHistoryApiVO;
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialCostPriceApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getDailyRentList())) {
            for (ChangeDailyRentVO detailVO : vo.getDailyRentList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getMonthRentList())) {
            for (ChangeDailyRentVO detailVO : vo.getMonthRentList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getNumRentList())) {
            for (ChangeDailyRentVO detailVO : vo.getNumRentList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getUnitPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getUnitTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.contractService.costPriceParams(materialPriceHistoryApiVO, "P-rzH7060210", "\u5408\u540c");
        return paramsCheckVO;
    }

    public ChangeEntity queryChangeList(ChangeEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ChangeEntity::getContractId, (Object)entity.getMainContractId());
        if (entity.getId() != null) {
            wrapper.ne(BaseEntity::getId, (Object)entity.getId());
        }
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            return (ChangeEntity)((Object)list.get(0));
        }
        return null;
    }
}

