/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.rmat.service.impl;

import com.ejianc.business.pro.rmat.bean.TotalPlanChangeEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanDetailChangeEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanDetailEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanDetailHistoryEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanEntity;
import com.ejianc.business.pro.rmat.bean.TotalPlanHistoryEntity;
import com.ejianc.business.pro.rmat.service.ITotalPlanChangeService;
import com.ejianc.business.pro.rmat.service.ITotalPlanDetailHistoryService;
import com.ejianc.business.pro.rmat.service.ITotalPlanDetailService;
import com.ejianc.business.pro.rmat.service.ITotalPlanHistoryService;
import com.ejianc.business.pro.rmat.service.ITotalPlanService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="totalPlanChange")
public class TotalPlanChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String TOTAL_PLAN_BILL_TYPE = "BT220209000000005";
    public static final String TOTAL_PLAN_CHANGE_BILL_TYPE = "BT220211000000005";
    public static final String TOTAL_PLAN_SOURCE_TYPE = "proTotalPlan";
    public static final String TOTAL_PLAN_CHANGE_SOURCE_TYPE = "proTotalPlanChange";
    @Autowired
    private ITotalPlanChangeService changeService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private ITotalPlanDetailService totalDetailService;
    @Autowired
    private ITotalPlanHistoryService historyService;
    @Autowired
    private ITotalPlanDetailHistoryService historyDetailService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("--------------\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\uff0c\u5904\u7406\u4e1a\u52a1");
        TotalPlanChangeEntity entity = (TotalPlanChangeEntity)((Object)this.changeService.selectById(billId));
        List<TotalPlanDetailChangeEntity> yearPlanChangeDetailEntities = entity.getDetailList();
        TotalPlanEntity contractEntity = (TotalPlanEntity)((Object)this.totalPlanService.selectById(entity.getTotalId()));
        this.logger.info("--------------\u540c\u6b65\u539f\u59cb\u603b\u8ba1\u5212\u5230\u8bb0\u5f55\u8868");
        TotalPlanHistoryEntity historyEntity = (TotalPlanHistoryEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), TotalPlanHistoryEntity.class));
        historyEntity.setTotalId(entity.getTotalId());
        historyEntity.setId(null);
        historyEntity.setCreateTime(new Date());
        historyEntity.setDetailList(null);
        this.historyService.saveOrUpdate((Object)historyEntity, false);
        this.logger.info("--------------\u540c\u6b65\u539f\u59cb\u603b\u8ba1\u5212\u6e05\u5355\u5230\u8bb0\u5f55\u8868");
        List<TotalPlanDetailEntity> checkList = contractEntity.getDetailList();
        if (null != checkList && checkList.size() > 0) {
            List historyDetails = BeanMapper.mapList(checkList, TotalPlanDetailHistoryEntity.class);
            for (TotalPlanDetailHistoryEntity hde : historyDetails) {
                hde.setHistoryId(historyEntity.getId());
                hde.setTotalId(entity.getTotalId());
                hde.setTotalBid(hde.getId());
                hde.setId(null);
            }
            this.historyDetailService.saveOrUpdateBatch(historyDetails, historyDetails.size(), false);
        }
        TotalPlanEntity newEntity = (TotalPlanEntity)((Object)BeanMapper.map((Object)((Object)entity), TotalPlanEntity.class));
        newEntity.setId(contractEntity.getId());
        newEntity.setBaseMny(contractEntity.getBaseMny());
        newEntity.setChangingMny(null);
        newEntity.setChangeStatus(3);
        newEntity.setChangeCode(contractEntity.getChangeCode());
        newEntity.setChangeId(contractEntity.getChangeId());
        newEntity.setBillState(contractEntity.getBillState());
        newEntity.setCreateTime(contractEntity.getCreateTime());
        newEntity.setVersion(contractEntity.getVersion());
        newEntity.setDetailList(null);
        this.logger.info("--------------\u53d8\u66f4\u603b\u8ba1\u5212\u56de\u5199\u5230\u539f\u59cb\u603b\u8ba1\u5212");
        this.totalPlanService.saveOrUpdate((Object)newEntity);
        this.logger.info("--------------\u53d8\u66f4\u603b\u8ba1\u5212\u6e05\u5355\u56de\u5199\u5230\u539f\u59cb\u603b\u8ba1\u5212\u6e05\u5355");
        this.totalPlanService.delByPlanId(contractEntity.getId());
        if (CollectionUtils.isNotEmpty(yearPlanChangeDetailEntities)) {
            List detailEntitys = BeanMapper.mapList(yearPlanChangeDetailEntities, TotalPlanDetailEntity.class);
            for (TotalPlanDetailEntity detailEntity : detailEntitys) {
                detailEntity.setTotalId(entity.getTotalId());
            }
            this.totalDetailService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
        }
        this.logger.info("--------------\u5904\u7406\u603b\u8ba1\u5212\u53d8\u66f4\u5355");
        entity.setUsedTime(new Date());
        this.changeService.saveOrUpdate((Object)entity, false);
        this.logger.info("--------------\u5904\u7406\u53d8\u66f4\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), TOTAL_PLAN_CHANGE_BILL_TYPE, TOTAL_PLAN_CHANGE_SOURCE_TYPE, String.valueOf(contractEntity.getId()), TOTAL_PLAN_BILL_TYPE, TOTAL_PLAN_SOURCE_TYPE);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

