package com.ejianc.business.pro.ownrmat.controller;

import com.ejianc.business.pro.ownrmat.service.IValidateService;
import com.ejianc.business.pro.ownrmat.utils.MaterialConstant;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * 材料公共接口
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("validate")
public class ValidateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IValidateService service;

    /**
     *  校验同一个项目只能存在一个自由态或审批中的单据（调出、处置、摊销）
     * @param projectId    项目主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @return
     */
    @RequestMapping(value = "/validateProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateProject(@RequestParam("projectId") Long projectId,
           @RequestParam(value = "billType", required = false) String billType,
           @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateProject(projectId, billType, billId, MaterialConstant.保存);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @Description getLastDate 获取最大单据日期
     * @param params contractId，billType，billId
     */
    @RequestMapping(value = "/getLastDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Date> getLastDate(@RequestParam(required = false) Map<String, Object> params) {
        Date date = service.getLastDate(params);
        return CommonResponse.success("校验成功！", date);
    }
}
