package com.ejianc.business.pro.ownrmat.controller.api;

import com.ejianc.business.pro.ownrmat.service.IAllotInService;
import com.ejianc.business.pro.ownrmat.service.IAllotOutService;
import com.ejianc.business.pro.ownrmat.vo.AllotInVO;
import com.ejianc.business.pro.ownrmat.vo.AllotOutVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController()
@RequestMapping("/api/rmatAllot/")
public class RmatAllotApi {

    @Autowired
    private IAllotOutService outService;

    @Autowired
    private IAllotInService inService;

    @PostMapping("rmatCreateAllotIn")
    public CommonResponse<String> rmatCreateAllotIn(@RequestBody AllotOutVO allotOutVO){
        String allotIn = outService.rmatCreateAllotIn(allotOutVO);
        return CommonResponse.success(allotIn);
    }

    @PostMapping("rmatSureToReturn")
    public CommonResponse<String> rmatSureToReturn(@RequestBody AllotInVO allotInVO){
        String allotIn = inService.rmatSureToReturn(allotInVO);
        return CommonResponse.success(allotIn);
    }

    @PostMapping("rmatSureToReceive")
    public CommonResponse<String> rmatSureToReceive(@RequestBody AllotInVO allotInVO){
        String allotIn = inService.rmatSureToReceive(allotInVO);
        return CommonResponse.success(allotIn);
    }



}
