package com.ejianc.business.pro.ownrmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMZZCRKDApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMZZCCZDVO;
import com.ejianc.business.pro.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.pro.ownrmat.bean.HandleDetailEntity;
import com.ejianc.business.pro.ownrmat.bean.HandleEntity;
import com.ejianc.business.pro.ownrmat.service.IHandleService;
import com.ejianc.business.pro.ownrmat.service.IValidateService;
import com.ejianc.business.pro.rmat.utils.MaterialConstant;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.pro.ownrmat.vo.HandleVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

@Service("handle") 
public class HandleBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IHandleService service;

	@Autowired
	private IStoreManageApi storeManageApi;

	@Autowired
	private IValidateService validateService;

	@Autowired
	private HandleServiceImpl handleService;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IPMZZCRKDApi ipmzzcrkdApi;

	@Autowired
	private ICostDetailApi costDetailApi;
	@Value("${contract.generateBillCodeType:common}")
	private String GenerateBillCodeType;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		HandleEntity handleEntity = service.selectById(billId);
		HandleVO handleVO = BeanMapper.map(handleEntity, HandleVO.class);
		validateService.validateHandle(handleVO);
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		HandleEntity outStoreEntity = service.selectById(billId);
		//调用库存逻辑
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setStoreId(outStoreEntity.getProjectId());
		storeManageVO.setSourceId(outStoreEntity.getId());
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材材料处置);
		storeManageVO.setOutEffectiveON(true);
		ArrayList<FlowVO> flowVOS = new ArrayList<>();
		outStoreEntity.getHandleSubList().forEach(t->{
			FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材材料处置, 0);
			flowVO.setStoreId(outStoreEntity.getProjectId());
			flowVO.setStoreName(outStoreEntity.getProjectName());
			flowVO.setProjectId(outStoreEntity.getProjectId());
			flowVO.setProjectName(outStoreEntity.getProjectName());
			flowVO.setOrgId(outStoreEntity.getOrgId());
			flowVO.setOrgName(outStoreEntity.getOrgName());
			flowVO.setParentOrgId(outStoreEntity.getParentOrgId());
			flowVO.setParentOrgName(outStoreEntity.getParentOrgName());
			flowVO.setEmployeeId(outStoreEntity.getEmployeeId());
			flowVO.setEmployeeName(outStoreEntity.getEmployeeName());
			flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
			flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
			flowVO.setMaterialId(t.getMaterialId());
			flowVO.setMaterialName(t.getMaterialName());
			flowVO.setMaterialSpec(t.getSpec());
			flowVO.setMaterialUnitId(t.getUnit());
			flowVO.setMaterialUnitName(t.getUnitName());
			flowVO.setSourceBillDetailRemark(t.getMemo());
			flowVO.setTaxPrice(t.getHandleTaxPrice());
			flowVO.setPrice(t.getHandlePrice());
			flowVO.setNum(t.getHandleNum());
			flowVO.setTaxMny(t.getHandleTaxMny());
			flowVO.setMny(t.getHandleMny());
			flowVO.setTax(t.getTax());
			flowVO.setSourceId(outStoreEntity.getId());
			flowVO.setSourceDetailId(t.getId());
			flowVO.setSourceBillCode(outStoreEntity.getBillCode());
			flowVO.setSourceBillDate(outStoreEntity.getHandleDate());
			flowVO.setRowState(t.getRowState());
			flowVO.setSourceBillRemark(outStoreEntity.getHandleReason());
			flowVOS.add(flowVO);
		});
		storeManageVO.setFlowVOList(flowVOS);
		CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
		if(!response.isSuccess()) {
			return CommonResponse.error("调用库存管理失败,错误信息："+response.getMsg());
		}else{
			logger.info("推送成本---");
			service.costPush(outStoreEntity);

			//周转材 -推财务 --郑州一建业务
			if ("common".equals(GenerateBillCodeType)){
				List<HandleDetailEntity> handleDetailEntities = outStoreEntity.getHandleSubList();
				if(CollectionUtils.isNotEmpty(handleDetailEntities)){
					List<PMZZCCZDVO> list = new ArrayList<>();
					handleDetailEntities.forEach(e->{
						PMZZCCZDVO czdvo = new PMZZCCZDVO();
						czdvo.setOrgName(outStoreEntity.getOrgName());
						czdvo.setMaterialId(e.getMaterialId()==null?"":e.getMaterialId().toString());
						czdvo.setMaterialName(e.getMaterialName());
						czdvo.setMaterialTypeName(e.getMaterialCategoryName());
						czdvo.setSpec(e.getSpec());
						czdvo.setUnitName(e.getUnitName());
						czdvo.setHandleNum(e.getHandleNum());
						czdvo.setHandleTaxPrice(e.getHandleTaxPrice());
						czdvo.setHandleTaxMny(e.getHandleTaxMny());
						czdvo.setNetWorthTaxMny(e.getNetWorthTaxMny());
						czdvo.setOriginalValueTaxMny(e.getOriginalValueTaxMny());
						czdvo.setHandleSubTaxMny(e.getHandleSubTaxMny());
						czdvo.setSourceId(e.getId().toString());
						list.add(czdvo);
					});
					logger.info("周转材调用财务参数：" +JSONObject.toJSONString(list));
					ipmzzcrkdApi.saveCzd(list);
				}
			}

			return CommonResponse.success();
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.error(res.getMsg());
		}
		HandleEntity outStoreEntity = service.selectById(billId);
		// 同一个合同只能存在一个自由态或审批中的单据
		validateService.validateProject(outStoreEntity.getProjectId(), null, null, MaterialConstant.弃审);
		// 校验必须大于最大单据日期
		handleService.validateTime(BeanMapper.map(outStoreEntity, HandleVO.class), MaterialConstant.弃审);
		List<Long> ids = new ArrayList<>();
		ids.add(billId);
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setStoreId(outStoreEntity.getProjectId());
		storeManageVO.setSourceIdsForRollBack(ids);
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材材料处置);
		storeManageVO.setOutEffectiveON(true);
		CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
		if(!response.isSuccess()) {
			return CommonResponse.error("调用库存管理失败,错误信息："+response.getMsg());
		}else{
			return CommonResponse.success();
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		HandleEntity outStoreEntity = service.selectById(billId);
		logger.info("删除成本---");

		CommonResponse<String> stringCommonResponse = costDetailApi.updateCostDetail(billId,0);
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<HandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(HandleEntity::getId, billId);
		updateWrapper.set(HandleEntity::getRelationFlag, "0");//(1:是，0：否)
		service.update(updateWrapper);
		//周转材 -推财务
		if ("common".equals(GenerateBillCodeType)){
			List<HandleDetailEntity> handleDetailEntities = outStoreEntity.getHandleSubList();
			if(CollectionUtils.isNotEmpty(handleDetailEntities)){
				List<String> list = new ArrayList<>();
				handleDetailEntities.forEach(e->{
					list.add(e.getId().toString());
				});
				logger.info("弃审周转材调用财务参数：" +JSONObject.toJSONString(list));
				ipmzzcrkdApi.deleteCzd(list);
			}
		}

		return CommonResponse.success();
	}

}
