package com.ejianc.business.pro.rmat.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 周转材批次计划-清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prormat_batch_plan_detail")
public class BatchPlanDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="batch_id")
    private Long batchId; // 批次计划主键
    @TableField(value="material_type_id")
    private Long materialTypeId; // 材料分类id
    @TableField(value="material_type_name")
    private String materialTypeName; // 材料分类名称
    @TableField(value="material_id")
    private Long materialId; // 材料id
    @TableField(value="material_name")
    private String materialName; // 材料名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="num")
    private BigDecimal num; // 计划总量
    @TableField(value="mny")
    private BigDecimal mny; // 暂估金额/租赁金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="plan_use_time")
    private Date planUseTime; // 计划开始使用时间/计划进场时间
    @TableField(value="standard")
    private String standard; // 质量验收标准或要求
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="source_id")
    private Long sourceId; // 物资来源出业务Id
    @TableField(value="source_type")
    private Integer sourceType; // 来源,1-目标成本，2-材料档案，3-总计划
    @TableField(value="unit_id")
    private Long unitId; // 计量单位id


    @TableField(value="calculate_type")
    private Integer calculateType; // 计量方式(0-理计,1-过磅,2-点数)
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="price_tax")
    private BigDecimal priceTax; // 单价(含税)
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="rate")
    private BigDecimal rate; // 税率
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="plan_leave_date")
    private Date planLeaveDate; // 计划出场时间
    @TableField(value="plan_day")
    private BigDecimal planDay; // 计划周期/租赁天数/租赁月数

    @TableField(value="mny_no_tax")
    private BigDecimal mnyNoTax; // 租赁金额(无税)

    @TableField(value = "lack_month_day_unit_price")
    private BigDecimal lackMonthDayUnitPrice; // 不足月日单价(无税)
    @TableField(value = "lack_month_day_unit_tax_price")
    private BigDecimal lackMonthDayUnitTaxPrice; // 不足月日单价
    @TableField(value = "rent_days")
    private Integer rentDays; // 租赁天数-- 不足月天数

    @TableField(value="rent_num")
    private BigDecimal rentNum; // 租赁数量

    @TableField(value="history_price_area")
    private String historyPriceArea;//历史价格区间（无税）
    @TableField(value="history_tax_price_area")
    private String historyTaxPriceArea;//历史价格区间（含税）
    @TableField(value="guide_price_area")
    private String guidePriceArea; // 公司指导价区间（无税）
    @TableField(value="guide_tax_price_area")
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    
    

    public Long getBatchId() {
        return batchId;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Date getPlanUseTime() {
        return planUseTime;
    }

    public void setPlanUseTime(Date planUseTime) {
        this.planUseTime = planUseTime;
    }
    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPriceTax() {
        return priceTax;
    }

    public void setPriceTax(BigDecimal priceTax) {
        this.priceTax = priceTax;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }

    public BigDecimal getMnyNoTax() {
        return mnyNoTax;
    }

    public void setMnyNoTax(BigDecimal mnyNoTax) {
        this.mnyNoTax = mnyNoTax;
    }

    public BigDecimal getLackMonthDayUnitPrice() {
        return lackMonthDayUnitPrice;
    }

    public void setLackMonthDayUnitPrice(BigDecimal lackMonthDayUnitPrice) {
        this.lackMonthDayUnitPrice = lackMonthDayUnitPrice;
    }

    public BigDecimal getLackMonthDayUnitTaxPrice() {
        return lackMonthDayUnitTaxPrice;
    }

    public void setLackMonthDayUnitTaxPrice(BigDecimal lackMonthDayUnitTaxPrice) {
        this.lackMonthDayUnitTaxPrice = lackMonthDayUnitTaxPrice;
    }

    public Integer getRentDays() {
        return rentDays;
    }

    public void setRentDays(Integer rentDays) {
        this.rentDays = rentDays;
    }

    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }
}
