package com.ejianc.business.pro.rmat.service;


import com.ejianc.business.pro.rmat.bean.CheckEntity;
import com.ejianc.business.pro.rmat.bean.DeliveryDetailEntity;
import com.ejianc.business.pro.rmat.bean.DeliveryEntity;
import com.ejianc.business.pro.rmat.bean.OrderEntity;
import com.ejianc.business.pro.rmat.vo.DeliveryVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 周转材租赁-送货单
 * 
 * @author generator
 * 
 */
public interface IDeliveryService extends IBaseService<DeliveryEntity> {

    /**
     * 单据保存
     *
     * @param request
     */
    String saveSyncBill(HttpServletRequest request);

    /**
     * 单据确认
     *
     * @param entity
     */
    String updateBillConfirmState(DeliveryEntity entity);

    /**
     * 单据作废
     *
     * @param entity
     * @return
     */
    String billDel(DeliveryEntity entity);


    void submitChangeDeliveryNums(List<DeliveryDetailEntity> deliveryDetailList);

    void backChangeDeliveryNums(List<DeliveryDetailEntity> deliveryDetailList);

    void submitChangeDeliveryState(Long orderId,List<DeliveryDetailEntity> detailEntities);

    void backChangeDeliveryState(Long orderId,List<DeliveryDetailEntity> detailEntities);


    /**
     * 改状态
     * @param entity
     * @return
     */
    String changeCloseState(DeliveryEntity entity);

}
