package com.ejianc.business.pro.rmat.service;

import com.ejianc.business.pro.rmat.vo.RestituteVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.pro.rmat.bean.RestituteEntity;

import javax.servlet.http.HttpServletRequest;

/**
 * 退赔单
 * 
 * @author generator
 * 
 */
public interface IRestituteService extends IBaseService<RestituteEntity> {

    String validateContract(Long contractId, Long billId);

    String validateTime(RestituteVO saveOrUpdateVO,String type);

    /**
     * 单据推送到供方协同服务
     *
     * @param entity 待推送单据
     * @return
     */
    boolean pushBillToSupCenter(RestituteEntity entity);

    /**
     * 同步单据供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    boolean delPushBill(RestituteEntity entity);

    void delById(Long id);
}
