package com.ejianc.business.pro.rmat.service;

import com.ejianc.business.pro.rmat.bean.ContractEntity;
import com.ejianc.business.pro.rmat.bean.SettleEntity;
import com.ejianc.business.pro.rmat.vo.LoseVO;
import com.ejianc.business.pro.rmat.vo.RentCalculateVO;
import com.ejianc.business.pro.rmat.vo.RestituteVO;
import com.ejianc.business.pro.rmat.vo.SettleVO;
import com.ejianc.business.pro.rmat.vo.record.SettleRecordVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 周转材租赁结算单
 * 
 * @author generator
 * 
 */
public interface ISettleService extends IBaseService<SettleEntity> {

    SettleVO saveOrUpdate(SettleVO saveOrUpdateVO);
    
    String validateContract(Long contractId, Long billId);

    List<RentCalculateVO> queryCalculateData(Long contractId, String lastSettleDate, String settleDate);
    
    List<RestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate);

    List<LoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate);

    SettleVO queryLastSettleTaxMny(Long contractId, Long billId);

    SettleRecordVO querySettleRecord(Long id);
    
    Boolean pushSettleToPool(SettleVO vo);

    Boolean delSettleFromPool(Long id);

    ExecutionVO targetCost(SettleEntity entity);

    Boolean pushContract(SettleVO vo, String updateLevel,Boolean type);
    
    Boolean pushBillToSupCenter(SettleEntity entity);

    Boolean delPushBill(SettleEntity entity);

    String updateBillSupSignSyncInfo(HttpServletRequest request);

    ParamsCheckVO checkParams(SettleVO vo);

    CommonResponse<SettleVO> pushCost(SettleVO vo);

    void costPush(SettleEntity entity);

    void pullCost(Long id);

    Boolean syncPushExecution(@RequestParam(value = "id") Long id);

    void delById(Long id);

    ExecutionVO targetFinishCost(SettleEntity entity);
    List<DetailExecutionVO> numDetailExecution(ContractEntity contractEntity, List<SettleEntity> list,Long sourceId);
}
