package com.ejianc.business.pro.rmat.service;

import com.ejianc.business.pro.rmat.bean.StartEntity;
import com.ejianc.business.pro.rmat.vo.StartVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;

/**
 * 启用单实体
 * 
 * @author generator
 * 
 */
public interface IStartService extends IBaseService<StartEntity> {

    StartVO saveOrUpdate(StartVO saveOrUpdateVO);

    String validateContract(Long contractId, Long billId);

    String validateTime(StartVO startVO, String type);

    /**
     * 单据推送到供方协同服务
     *
     * @param entity 待推送单据
     * @return
     */
    boolean pushBillToSupCenter(StartEntity entity);

    /**
     * 同步单据供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    boolean delPushBill(StartEntity entity);

    void delById(Long id);
}
