package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.business.pro.rmat.bean.*;
import com.ejianc.business.pro.rmat.service.*;
import com.ejianc.business.pro.rmat.vo.*;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.rmat.mapper.BatchPlanMapper;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周转材批次计划
 *
 * @author generator
 */
@Service("batchPlanService")
public class BatchPlanServiceImpl extends BaseServiceImpl<BatchPlanMapper, BatchPlanEntity> implements IBatchPlanService {
    private static final String BILL_CODE = "PRO_BATCH_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBatchPlanDetailService batchPlanDetailService;
    @Autowired
    private IBatchPlanRepairService batchPlanRepairService;
    @Autowired
    private IBatchPlanScrapService batchPlanScrapService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PLAN_MNY_PARAM_CODE = "P-RRm6q40229";//【总计划金额】控【批次计划金额】
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    //【周转材历史最高价】 控【周转材批次计划价格】
    private final String HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-51k1640278";
    //【周转材历史最低价】 控【周转材批次计划价格】
    private final String HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-u8W93b0277";
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;



    @Override
    public BatchPlanVO saveOrUpdate(BatchPlanVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BatchPlanEntity entity = null;
        String operateType = null;
        saveorUpdateVO.setTenderStatus(0);
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, BatchPlanEntity.class);
            operateType = "edit";
        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, BatchPlanEntity.class);
            operateType = "add";
        }
        List<BatchPlanDetailVO> detailList = saveorUpdateVO.getDetailList();
        String categoryName = "";
        List<String> nameList = new ArrayList<>();
        for (BatchPlanDetailVO detailVO : detailList) {
            if (!nameList.contains(detailVO.getMaterialTypeName())) {
                if (categoryName.length() > 0) {
                    categoryName = categoryName + "," + detailVO.getMaterialTypeName();
                } else {
                    categoryName = detailVO.getMaterialTypeName();
                }
                nameList.add(detailVO.getMaterialTypeName());
                if (categoryName.length() > 100) {
                    break;
                }
            }
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate(entity);
        //更新子表信息
        if ("edit".equals(operateType)) {
            baseMapper.delByBatchId(entity.getId());
            baseMapper.delScrpByBatchId(entity.getId());
            baseMapper.delRepariByBatchId(entity.getId());
        }
        detailList = detailList.stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toList());
        if (detailList.size() > 0) {
            List<BatchPlanDetailEntity> detailEntityList = BeanMapper.mapList(detailList,BatchPlanDetailEntity.class);
            for(BatchPlanDetailEntity detailEntity : detailEntityList){
                detailEntity.setBatchId(entity.getId());
            }
            batchPlanDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        List<BatchPlanRepairVO> batchPlanRepairList = saveorUpdateVO.getRepairList().stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toList());
        if (batchPlanRepairList.size() > 0) {
            List<BatchPlanRepairEntity> repairEntityList = BeanMapper.mapList(batchPlanRepairList,BatchPlanRepairEntity.class);
            for(BatchPlanRepairEntity repairEntity : repairEntityList){
                repairEntity.setBatchId(entity.getId());
            }
            batchPlanRepairService.saveOrUpdateBatch(repairEntityList, repairEntityList.size(), false);
        }
        List<BatchPlanScrapVO> batchPlanScrapList = saveorUpdateVO.getScrapList().stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toList());
        if (batchPlanScrapList.size() > 0) {
            List<BatchPlanScrapEntity> scrapEntityList = BeanMapper.mapList(batchPlanScrapList,BatchPlanScrapEntity.class);
            for(BatchPlanScrapEntity scrapEntity : scrapEntityList){
                scrapEntity.setBatchId(entity.getId());
            }
            batchPlanScrapService.saveOrUpdateBatch(scrapEntityList, scrapEntityList.size(), false);
        }
        return queryDetail(entity.getId());
    }

    @Override
    public BatchPlanVO queryDetail(Long id) {
        BatchPlanEntity batchPlanEntity = super.selectById(id);
        BatchPlanVO vo = BeanMapper.map(batchPlanEntity,BatchPlanVO.class);
        return vo;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        if (StringUtils.isEmpty(BatchPlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<BatchPlanEntity> entityList = (List<BatchPlanEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (BatchPlanEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (BatchPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getTenderStatus())) {
                        throw new BusinessException("采购计划编码【" + entity.getBillCode() + "】项目名称【" +
                                entity.getProjectName() + "】已采购完成！");
                    }

                    entity.setTenderStatus(planState);
                }
//                entityList.forEach(entity -> {
//                    entity.setPlanState(planState);
//                });
                super.saveOrUpdateBatch(entityList);
            }
        }
    }

    /**
     * 参数控制
     * @param vo
     * @return
     */
    @Override
    public ParamsCheckVO checkParams(BatchPlanVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMasterPlanMny(vo));//总计划控制批次计划金额

        // 历史价控 总计划价
        paramsCheckVOS.addAll(this.historyPriceCtrlPlanPrice(vo));

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    public List<ParamsCheckVO>  historyPriceCtrlPlanPrice(BatchPlanVO batchPlanVO) {
        logger.info("proequipment---BatchPlanServiceImpl---historyPriceCtrlPlanPrice()--- 历史价控总计划价入参：{}", JSONObject.toJSONString(batchPlanVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        List<BatchPlanDetailVO> detailList = batchPlanVO.getDetailList();

        maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MAX_PRICE_CTRL_PLAN_PRICE, batchPlanVO.getOrgId());
        minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MIN_PRICE_CTRL_PLAN_PRICE, batchPlanVO.getOrgId());

        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("周转材租赁合同历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("周转材租赁合同历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        //todo 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.周转材价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.周转材价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (BatchPlanDetailVO  detailVO: detailList) {//遍历明细
                    if (detailVO.getRowState() != null && detailVO.getRowState().equals("del")){
                        continue;
                    }
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("明细：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                //日租
                for (BatchPlanDetailVO  detailVO: detailList) {//遍历明细
                    if (detailVO.getRowState() != null && detailVO.getRowState().equals("del")){
                        continue;
                    }
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getMaterialName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }


    /**
     * 单据管控-批次计划金额大于总计划金额
     *
     * @return
     */
    public List<ParamsCheckVO> checkParamsByMasterPlanMny(BatchPlanVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal temporaryMoney = vo.getEstimatedMnyNoTax() == null ? vo.getEstimatedMny() : vo.getEstimatedMnyNoTax();//本次批次计划金额
        BigDecimal planTaxMny;//总计划金额
        BigDecimal totalMoney = temporaryMoney;//累计批次计划金额  默认赋值本次
        //查询总计划
        LambdaQueryWrapper<TotalPlanEntity> planLambda = new LambdaQueryWrapper<>();
        planLambda.eq(TotalPlanEntity::getProjectId, vo.getProjectId());
        planLambda.in(TotalPlanEntity::getBillState, 1, 3);
        planLambda.eq(TotalPlanEntity::getDr, 0);
        List<TotalPlanEntity> planList = totalPlanService.list(planLambda);
        if (CollectionUtils.isNotEmpty(planList)) {
            planTaxMny = planList.stream().filter(e -> null != e.getEstimatedMny()).map(TotalPlanEntity::getEstimatedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            return paramsCheckVOS;
        }
        //查询批次计划
        LambdaQueryWrapper<BatchPlanEntity> Lambda = new LambdaQueryWrapper<>();
        Lambda.eq(BatchPlanEntity::getProjectId, vo.getProjectId());
        Lambda.in(BatchPlanEntity::getBillState, 1, 3);
        List<BatchPlanEntity> list = super.list(Lambda);//查询项目下所有批次计划
        if (CollectionUtils.isNotEmpty(list)) {
            for (BatchPlanEntity batchPlanEntity : list) {
                totalMoney = MathUtil.safeAdd(totalMoney, null != batchPlanEntity.getEstimatedMnyNoTax() ? batchPlanEntity.getEstimatedMnyNoTax() : batchPlanEntity.getEstimatedMny());
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PLAN_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总计划金额控制批次计划金额信息返回："+ JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(planTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("批次计划金额超总计划金额");
                        paramsCheckDsVO.setWarnName("累计批次计划金额大于总计划金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次批次计划金额：").append(temporaryMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计批次计划金额：").append(totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，总计划金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }
}
