package com.ejianc.business.pro.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.rmat.bean.*;
import com.ejianc.business.pro.rmat.mapper.TotalPlanMapper;
import com.ejianc.business.pro.rmat.service.ITotalPlanChangeService;
import com.ejianc.business.pro.rmat.service.ITotalPlanDetailService;
import com.ejianc.business.pro.rmat.service.ITotalPlanHistoryService;
import com.ejianc.business.pro.rmat.service.ITotalPlanService;
import com.ejianc.business.pro.rmat.utils.SortUtil;
import com.ejianc.business.pro.rmat.utils.TreeNodeBUtil;
import com.ejianc.business.pro.rmat.vo.PlanContrastV0;
import com.ejianc.business.pro.rmat.vo.TotalPlanDetailVO;
import com.ejianc.business.pro.rmat.vo.TotalPlanVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材总计划
 *
 * @author generator
 */
@Service("totalPlanService")
public class TotalPlanServiceImpl extends BaseServiceImpl<TotalPlanMapper, TotalPlanEntity> implements ITotalPlanService {
    private static final String BILL_CODE = "PRO_TOTAL_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITotalPlanDetailService detailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private ITotalPlanChangeService changeService;
    @Autowired
    private ITotalPlanHistoryService historyService;

    @Override
    public TotalPlanVO saveOrUpdateTotalPlan(TotalPlanVO saveorUpdateVO,Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanEntity entity = null;
        String operateType = null;

        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, TotalPlanEntity.class);
            operateType = "edit";
        } else {
            //新增
            //校验项目是否已有总计划
            LambdaQueryWrapper<TotalPlanEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(TotalPlanEntity::getProjectId, saveorUpdateVO.getProjectId());
            lambd.eq(TotalPlanEntity::getDr, BaseVO.DR_UNDELETE);
            List<TotalPlanEntity> list = super.list(lambd);
            if (null != list && list.size() > 0) {
                throw new BusinessException("保存失败，该项目下已存在周转材总计划，请勿重复添加！");
            }
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, TotalPlanEntity.class);
            entity.setChangeStatus(1);//未变更
            entity.setId(IdWorker.getId());
            operateType = "add";
        }
        entity.setBaseMny(entity.getEstimatedMny());
        if (!isControl){
            super.saveOrUpdate(entity);
            //更新子表信息
//            if ("edit".equals(operateType)) {
//                baseMapper.delByPlanId(entity.getId());
//            }
        }else{
            List<TotalPlanDetailEntity> detailEntityList = entity.getDetailList();
            List<TotalPlanDetailEntity> detailEntityListNew = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(detailEntityList)){
                for(TotalPlanDetailEntity cdEntity : detailEntityList){
                    if(null == cdEntity.getId()){
                        cdEntity.setId(IdWorker.getId());
                    }
                    if (!"del".equals(cdEntity.getRowState())) {
                        detailEntityListNew.add(cdEntity);
                    }
                }
                entity.setDetailList(detailEntityListNew);
            }
        }
        TotalPlanVO totalPlanVO = null;
        List<TotalPlanDetailEntity> detailEntityList = entity.getDetailList();
        List<TotalPlanDetailEntity> detailEntitys = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (TotalPlanDetailEntity cdEntity : detailEntityList) {
                if("add".equals(cdEntity.getRowState())){
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (TotalPlanDetailEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                //变更类型
                cdEntity.setChangeType(0);
                cdEntity.setTotalId(entity.getId());
                if (!"del".equals(cdEntity.getRowState())) {
                    detailEntitys.add(cdEntity);
                }else{
                    delIds.add(cdEntity.getId());
                }
            }
        }
        if(!isControl){
            if (delIds.size() > 0) {
                detailService.removeByIds(delIds);
            }
            if (detailEntitys.size() > 0) {
                detailService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
            }
            totalPlanVO = queryDetail(entity.getId(), true);

            //目标成本推送
            String frontendBaseHost="";
            if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                frontendBaseHost = BASE_HOST_FRONTEND;
            }else{
                frontendBaseHost = baseHost;
            }
            String linkUrl =frontendBaseHost+"ejc-prormat-frontend/#/totalPlan/card?id="+entity.getId();
            ExecutionVO executionVO = targetCost(queryDetail(entity.getId(), false),linkUrl);
            logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
        }else{
            totalPlanVO = BeanMapper.map(entity, TotalPlanVO.class);
            totalPlanVO.setDetailList(BeanMapper.mapList(detailEntitys, TotalPlanDetailVO.class));
        }

        return totalPlanVO;
    }
    @Override
    public ExecutionVO targetCost(TotalPlanVO totalPlanVO,String linkUrl){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(totalPlanVO.getId());
        totalVO.setTenantId(totalPlanVO.getTenantId());
        totalVO.setBillCode(totalPlanVO.getBillCode());
        totalVO.setMemo(totalPlanVO.getMemo());
        totalVO.setBillType("BT220209000000005");
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材材料总计划.getCode());
        totalVO.setProjectId(totalPlanVO.getProjectId());
        totalVO.setBillDate(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE, null == totalPlanVO.getCreateTime() ?new Date() : totalPlanVO.getCreateTime()));
        totalVO.setOrgId(totalPlanVO.getOrgId());
        totalVO.setMoney(totalPlanVO.getEstimatedMny());
        totalVO.setTaxMoney(totalPlanVO.getEstimatedMny());
        totalVO.setLinkUrl(linkUrl);
        totalVO.setBillDate(totalPlanVO.getCreateTime()!=null?totalPlanVO.getCreateTime().toString():null);
        for (TotalPlanDetailVO planDetailVO : totalPlanVO.getDetailList()) {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId());
            detailExecutionVO.setSourceBillId(totalPlanVO.getId());
            detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
            detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
            //判断是否是分类
            if (planDetailVO.getMaterialId()==null){
                detailExecutionVO.setCategoryFlag(true);
            }
            detailExecutionVO.setCode(planDetailVO.getMaterialCode());
            detailExecutionVO.setCategoryFlag(false);
            detailExecutionVO.setCategoryContainFlag(false);
            //根据分类ID查询物料分类信息
            MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
            if (categoryVO==null){
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            }else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocId(planDetailVO.getSourceId()==null?1439116437228298666L:planDetailVO.getSourceId());
            detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
            detailExecutionVO.setName(planDetailVO.getMaterialName());
            detailExecutionVO.setSpec(planDetailVO.getSpec());
            detailExecutionVO.setUnitId(planDetailVO.getUnitId());
            detailExecutionVO.setUnitName(planDetailVO.getUnit());
            detailExecutionVO.setNum(planDetailVO.getNum());
            detailExecutionVO.setMoney(planDetailVO.getMny());
            detailExecutionVO.setTaxMoney(planDetailVO.getMny());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);

        return executionVO;
    }

    @Override
    public TotalPlanVO queryDetail(Long id, boolean detailHasChildren) {
        TotalPlanEntity entity = super.selectById(id);
        TotalPlanVO vo = BeanMapper.map(entity, TotalPlanVO.class);

        List<TotalPlanDetailVO> detailVoListDb = vo.getDetailList();
        List<TotalPlanDetailVO> detailVoList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailVoListDb)) {
            detailVoListDb.forEach(detailEntity -> {
                if (null == detailEntity.getChangeType() || 2 != detailEntity.getChangeType()) {
                    detailVoList.add(detailEntity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailVoList)) {
            for (TotalPlanDetailVO cdEntity : detailVoList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            new SortUtil<TotalPlanDetailVO>().entryListToSort(detailVoList, "treeIndex");
            if (detailHasChildren) {
                vo.setDetailList(TreeNodeBUtil.buildTree(detailVoList));
            } else {
                vo.setDetailList(detailVoList);
            }
        }

        return vo;
    }
    @Override
    public void delByPlanId(Long id) {
        baseMapper.delByPlanId(id);
    }

    @Override
    public void delByIds(List<TotalPlanVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)) {
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (TotalPlanVO masterPlanVO : vos) {
                ExecutionVO executionVO = targetCost(BeanMapper.map(baseMapper.selectById(masterPlanVO.getId()),TotalPlanVO.class),"");
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
            List<Long> ids = vos.stream().map(TotalPlanVO::getId).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(ids)) {
                super.removeByIds(ids);
            }
        }
    }

    @Override
    public ParamsCheckVO targetCostCtrl(TotalPlanVO totalPlanVO) {
        TotalPlanVO planVO = saveOrUpdateTotalPlan(totalPlanVO, true);
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        String linkUrl = frontendBaseHost + "ejc-prormat-frontend/#/totalPlan/card?id=" + planVO.getId();
        //目标成本推送
        ExecutionVO executionVO = targetCost(planVO, linkUrl);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        return response.getData();
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        TotalPlanVO planVO = queryDetail(id, true);
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        String linkUrl = frontendBaseHost + "ejc-prormat-frontend/#/totalPlan/card?id=" + planVO.getId();
        //目标成本推送
        ExecutionVO executionVO = targetCost(planVO, linkUrl);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        return response.getData();
    }

    @Override
    public List<TotalPlanEntity> listTotalPlanByProjectId(Long projectId){
        LambdaQueryWrapper<TotalPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalPlanEntity::getProjectId,projectId);
        queryWrapper.eq(TotalPlanEntity::getTenantId,InvocationInfoProxy.getTenantid());
        queryWrapper.eq(TotalPlanEntity::getDr,0);
        queryWrapper.in(TotalPlanEntity::getBillState,1,3);
        return super.list(queryWrapper);
    }

    @Override
    public Boolean syncPushExecution(Long id) {
        TotalPlanVO totalPlanVO = queryDetail(id, false);
        if(totalPlanVO.getChangeStatus() == 2){ // 变更中
            TotalPlanChangeEntity planChangeEntity = changeService.selectById(totalPlanVO.getChangeId());
            List<TotalExecutionVO> totalExecutionVOList0 = new ArrayList<>();
            ExecutionVO executionVO0 = this.targetCost(BeanMapper.map(planChangeEntity, TotalPlanVO.class),"");
            totalExecutionVOList0.add(executionVO0.getTotalVO());
            logger.info("目标成本变更删除数据" + JSON.toJSONString(totalExecutionVOList0));
            CommonResponse<String> response2 = executionApi.aggDel(totalExecutionVOList0);
            if (!response2.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response2.getMsg());
            }
            //目标成本推送
            String frontendBaseHost="";
            if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                frontendBaseHost = BASE_HOST_FRONTEND;
            }else{
                frontendBaseHost = baseHost;
            }
            String linkUrl =frontendBaseHost+"ejc-prormat-frontend/#/totalPlan/changeCard?id="+totalPlanVO.getChangeId();
            ExecutionVO executionVO = targetCost(BeanMapper.map(planChangeEntity, TotalPlanVO.class),linkUrl);
            logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
        } else {
            if(totalPlanVO.getChangeVersion() != 1){ // 已变更
                List<TotalExecutionVO> totalExecutionVOList1 = new ArrayList<>();
                LambdaQueryWrapper<TotalPlanChangeEntity> lam = new LambdaQueryWrapper<>();
                lam.eq(TotalPlanChangeEntity::getDr,0);
                lam.eq(TotalPlanChangeEntity::getTotalId,id);
                lam.eq(TotalPlanChangeEntity::getChangeVersion,totalPlanVO.getChangeVersion());
                lam.in(TotalPlanChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
                List<TotalPlanChangeEntity> list = changeService.list(lam);
                if(list != null && list.size() > 0){
                    //TotalPlanChangeEntity masterPlanChangeEntity = baseMapper.selectById(entity.getId());
                    TotalPlanChangeEntity masterPlanChangeEntity = list.get(0);
                    ExecutionVO executionVO2 = this.targetCost(BeanMapper.map(masterPlanChangeEntity, TotalPlanVO.class),"");
                    totalExecutionVOList1.add(executionVO2.getTotalVO());
                    logger.info("目标成本变更删除数据" + JSON.toJSONString(totalExecutionVOList1));
                    CommonResponse<String> response2 = executionApi.aggDel(totalExecutionVOList1);
                    if (!response2.isSuccess()) {
                        throw new BusinessException("目标成本推送失败," + response2.getMsg());
                    }
                }
            }
            //目标成本推送
            String frontendBaseHost="";
            if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                frontendBaseHost = BASE_HOST_FRONTEND;
            }else{
                frontendBaseHost = baseHost;
            }
            String linkUrl =frontendBaseHost+"ejc-prormat-frontend/#/totalPlan/card?id="+id;
            ExecutionVO executionVO = targetCost(totalPlanVO,linkUrl);
            logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()){
                throw new BusinessException("目标成本推送失败,"+response.getMsg());
            }
        }
        return true;
    }

    @Override
    public List<PlanContrastV0> getContrastInfo(Long planId, Long oldPlanId) {

        // 查询主合同子表
        LambdaQueryWrapper<TotalPlanDetailEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TotalPlanDetailEntity::getTotalId, planId);
        List<TotalPlanDetailEntity> list = detailService.list(wrapper);

        // 查询历史记录表
        LambdaQueryWrapper<TotalPlanHistoryEntity> historyWrapper = new LambdaQueryWrapper<>();
        historyWrapper.eq(TotalPlanHistoryEntity::getChangeId, oldPlanId);
        TotalPlanHistoryEntity historyEntity = historyService.getOne(historyWrapper);
        List<TotalPlanDetailHistoryEntity> historyEntityList = historyService.selectById(historyEntity.getId()).getDetailList();

        List<PlanContrastV0> voList = BeanMapper.mapList(list, PlanContrastV0.class);

        for (PlanContrastV0 vo : voList) {
            Map<Long, TotalPlanDetailHistoryEntity> map = historyEntityList.stream().collect(Collectors.toMap(TotalPlanDetailHistoryEntity::getSourceId, Function.identity()));
            if (map.containsKey(vo.getSourceId())) {
                TotalPlanDetailHistoryEntity entity = map.get(vo.getSourceId());
                vo.setOldNum(entity.getNum());
                vo.setOldMny(entity.getMny());
                vo.setOldPlanUseTime(entity.getPlanUseTime());
                vo.setOldStandard(entity.getStandard());
                vo.setOldMemo(entity.getMemo());
            }
        }

        return voList;
    }


}
